/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.nodetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class NodeTypeDefDiff {
    public static final int NONE = 0;
    public static final int TRIVIAL = 1;
    public static final int MAJOR = 2;
    private final QNodeTypeDefinition oldDef;
    private final QNodeTypeDefinition newDef;
    private int type;
    private final List<PropDefDiff> propDefDiffs = new ArrayList<PropDefDiff>();
    private final List<ChildNodeDefDiff> childNodeDefDiffs = new ArrayList<ChildNodeDefDiff>();

    private NodeTypeDefDiff(QNodeTypeDefinition oldDef, QNodeTypeDefinition newDef) {
        this.oldDef = oldDef;
        this.newDef = newDef;
        this.init();
    }

    private void init() {
        if (this.oldDef.equals(this.newDef)) {
            this.type = 0;
        } else {
            this.type = 1;
            int tmpType = this.supertypesDiff();
            if (tmpType > this.type) {
                this.type = tmpType;
            }
            if ((tmpType = this.mixinFlagDiff()) > this.type) {
                this.type = tmpType;
            }
            if ((tmpType = this.abstractFlagDiff()) > this.type) {
                this.type = tmpType;
            }
            if ((tmpType = this.buildPropDefDiffs()) > this.type) {
                this.type = tmpType;
            }
            if ((tmpType = this.buildChildNodeDefDiffs()) > this.type) {
                this.type = tmpType;
            }
        }
    }

    public static NodeTypeDefDiff create(QNodeTypeDefinition oldDef, QNodeTypeDefinition newDef) {
        if (oldDef == null || newDef == null) {
            throw new IllegalArgumentException("arguments can not be null");
        }
        if (!oldDef.getName().equals(newDef.getName())) {
            throw new IllegalArgumentException("at least node type names must be matching");
        }
        return new NodeTypeDefDiff(oldDef, newDef);
    }

    public boolean isModified() {
        return this.type != 0;
    }

    public boolean isTrivial() {
        return this.type == 1;
    }

    public boolean isMajor() {
        return this.type == 2;
    }

    public int getType() {
        return this.type;
    }

    public int mixinFlagDiff() {
        return this.oldDef.isMixin() != this.newDef.isMixin() ? 2 : 0;
    }

    public int abstractFlagDiff() {
        return this.oldDef.isAbstract() && !this.newDef.isAbstract() ? 2 : 0;
    }

    public int supertypesDiff() {
        HashSet<Name> set2;
        HashSet<Name> set1 = new HashSet<Name>(Arrays.asList(this.oldDef.getSupertypes()));
        return !((Object)set1).equals(set2 = new HashSet<Name>(Arrays.asList(this.newDef.getSupertypes()))) ? 2 : 0;
    }

    private int buildPropDefDiffs() {
        int maxType = 0;
        HashMap<QPropertyDefinitionId, QPropertyDefinition> oldDefs = new HashMap<QPropertyDefinitionId, QPropertyDefinition>();
        for (QPropertyDefinition def : this.oldDef.getPropertyDefs()) {
            oldDefs.put(new QPropertyDefinitionId(def), def);
        }
        HashMap<QPropertyDefinitionId, QPropertyDefinition> newDefs = new HashMap<QPropertyDefinitionId, QPropertyDefinition>();
        for (QPropertyDefinition def : this.newDef.getPropertyDefs()) {
            newDefs.put(new QPropertyDefinitionId(def), def);
        }
        for (Map.Entry entry : oldDefs.entrySet()) {
            QPropertyDefinition def2;
            QPropertyDefinitionId id = (QPropertyDefinitionId)entry.getKey();
            QPropertyDefinition def1 = (QPropertyDefinition)entry.getValue();
            PropDefDiff diff = new PropDefDiff(def1, def2 = (QPropertyDefinition)newDefs.get(id));
            if (diff.getType() > maxType) {
                maxType = diff.getType();
            }
            this.propDefDiffs.add(diff);
            newDefs.remove(id);
        }
        for (Map.Entry entry : newDefs.entrySet()) {
            QPropertyDefinition def = (QPropertyDefinition)entry.getValue();
            PropDefDiff diff = new PropDefDiff(null, def);
            if (diff.getType() > maxType) {
                maxType = diff.getType();
            }
            this.propDefDiffs.add(diff);
        }
        return maxType;
    }

    private int buildChildNodeDefDiffs() {
        ChildNodeDefDiffs childNodeDefDiffs;
        int maxType = 0;
        Map<QNodeDefinitionId, List<QNodeDefinition>> oldDefs = this.collectChildNodeDefs(this.oldDef.getChildNodeDefs());
        Map<QNodeDefinitionId, List<QNodeDefinition>> newDefs = this.collectChildNodeDefs(this.newDef.getChildNodeDefs());
        for (QNodeDefinitionId defId : oldDefs.keySet()) {
            childNodeDefDiffs = new ChildNodeDefDiffs(oldDefs.get(defId), newDefs.get(defId));
            this.childNodeDefDiffs.addAll(childNodeDefDiffs.getChildNodeDefDiffs());
            newDefs.remove(defId);
        }
        for (QNodeDefinitionId defId : newDefs.keySet()) {
            childNodeDefDiffs = new ChildNodeDefDiffs(null, newDefs.get(defId));
            this.childNodeDefDiffs.addAll(childNodeDefDiffs.getChildNodeDefDiffs());
        }
        for (ChildNodeDefDiff diff : this.childNodeDefDiffs) {
            if (diff.getType() <= maxType) continue;
            maxType = diff.getType();
        }
        return maxType;
    }

    private Map<QNodeDefinitionId, List<QNodeDefinition>> collectChildNodeDefs(QNodeDefinition[] cnda1) {
        HashMap<QNodeDefinitionId, List<QNodeDefinition>> defs1 = new HashMap<QNodeDefinitionId, List<QNodeDefinition>>();
        for (QNodeDefinition def1 : cnda1) {
            QNodeDefinitionId def1Id = new QNodeDefinitionId(def1);
            ArrayList<QNodeDefinition> list = (ArrayList<QNodeDefinition>)defs1.get(def1Id);
            if (list == null) {
                list = new ArrayList<QNodeDefinition>();
                defs1.put(def1Id, list);
            }
            list.add(def1);
        }
        return defs1;
    }

    public String toString() {
        String result = this.getClass().getName() + "[\n\tnodeTypeName=" + this.oldDef.getName();
        result = result + ",\n\tmixinFlagDiff=" + this.modificationTypeToString(this.mixinFlagDiff());
        result = result + ",\n\tsupertypesDiff=" + this.modificationTypeToString(this.supertypesDiff());
        result = result + ",\n\tpropertyDifferences=[\n";
        result = result + this.toString(this.propDefDiffs);
        result = result + "\t]";
        result = result + ",\n\tchildNodeDifferences=[\n";
        result = result + this.toString(this.childNodeDefDiffs);
        result = result + "\t]\n";
        result = result + "]\n";
        return result;
    }

    private String toString(List<? extends ChildItemDefDiff> childItemDefDiffs) {
        String result = "";
        Iterator<? extends ChildItemDefDiff> iter = childItemDefDiffs.iterator();
        while (iter.hasNext()) {
            ChildItemDefDiff propDefDiff = iter.next();
            result = result + "\t\t" + propDefDiff;
            if (iter.hasNext()) {
                result = result + ",";
            }
            result = result + "\n";
        }
        return result;
    }

    private String modificationTypeToString(int modificationType) {
        String typeString = "unknown";
        switch (modificationType) {
            case 0: {
                typeString = "NONE";
                break;
            }
            case 1: {
                typeString = "TRIVIAL";
                break;
            }
            case 2: {
                typeString = "MAJOR";
            }
        }
        return typeString;
    }

    private class ChildNodeDefDiffs {
        private final List<QNodeDefinition> defs1;
        private final List<QNodeDefinition> defs2;

        private ChildNodeDefDiffs(List<QNodeDefinition> defs1, List<QNodeDefinition> defs2) {
            this.defs1 = defs1 != null ? defs1 : Collections.emptyList();
            this.defs2 = defs2 != null ? defs2 : Collections.emptyList();
        }

        private Collection<ChildNodeDefDiff> getChildNodeDefDiffs() {
            ArrayList<ChildNodeDefDiff> diffs = new ArrayList<ChildNodeDefDiff>();
            for (QNodeDefinition def1 : this.defs1) {
                for (QNodeDefinition def2 : this.defs2) {
                    diffs.add(new ChildNodeDefDiff(def1, def2));
                }
            }
            if (this.defs2.size() < this.defs1.size()) {
                for (QNodeDefinition def1 : this.defs1) {
                    diffs.add(new ChildNodeDefDiff(def1, null));
                }
            }
            if (this.defs1.size() < this.defs2.size()) {
                for (QNodeDefinition def2 : this.defs2) {
                    diffs.add(new ChildNodeDefDiff(null, def2));
                }
            }
            Collections.sort(diffs, new Comparator<ChildNodeDefDiff>(){

                @Override
                public int compare(ChildNodeDefDiff o1, ChildNodeDefDiff o2) {
                    return o1.getType() - o2.getType();
                }
            });
            int size = this.defs1.size() > this.defs2.size() ? this.defs1.size() : this.defs2.size();
            AtomicInteger allowedNewNull = new AtomicInteger(this.defs1.size() - this.defs2.size());
            AtomicInteger allowedOldNull = new AtomicInteger(this.defs2.size() - this.defs1.size());
            ArrayList<ChildNodeDefDiff> results = new ArrayList<ChildNodeDefDiff>();
            for (ChildNodeDefDiff diff : diffs) {
                if (!this.alreadyMatched(results, diff.getNewDef(), diff.getOldDef(), allowedNewNull, allowedOldNull)) {
                    results.add(diff);
                    if (diff.getNewDef() == null) {
                        allowedNewNull.decrementAndGet();
                    }
                    if (diff.getOldDef() == null) {
                        allowedOldNull.decrementAndGet();
                    }
                }
                if (results.size() != size) continue;
                break;
            }
            return results;
        }

        private boolean alreadyMatched(List<ChildNodeDefDiff> result, QNodeDefinition newDef, QNodeDefinition oldDef, AtomicInteger allowedNewNull, AtomicInteger allowedOldNull) {
            boolean containsNewDef = false;
            boolean containsOldDef = false;
            for (ChildNodeDefDiff d : result) {
                if (d.getNewDef() != null && d.getNewDef().equals(newDef)) {
                    containsNewDef = true;
                    break;
                }
                if (d.getOldDef() == null || !d.getOldDef().equals(oldDef)) continue;
                containsOldDef = true;
                break;
            }
            if (oldDef == null && allowedOldNull.get() < 1) {
                containsOldDef = true;
            }
            if (newDef == null && allowedNewNull.get() < 1) {
                containsNewDef = true;
            }
            return containsNewDef || containsOldDef;
        }
    }

    static class QNodeDefinitionId {
        Name declaringNodeType;
        Name name;

        QNodeDefinitionId(QNodeDefinition def) {
            this.declaringNodeType = def.getDeclaringNodeType();
            this.name = def.getName();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof QNodeDefinitionId) {
                QNodeDefinitionId other = (QNodeDefinitionId)obj;
                return this.declaringNodeType.equals(other.declaringNodeType) && this.name.equals(other.name);
            }
            return false;
        }

        public int hashCode() {
            int h = 17;
            h = 37 * h + this.declaringNodeType.hashCode();
            h = 37 * h + this.name.hashCode();
            return h;
        }
    }

    static class QPropertyDefinitionId {
        Name declaringNodeType;
        Name name;
        boolean definesResidual;

        QPropertyDefinitionId(QPropertyDefinition def) {
            this.declaringNodeType = def.getDeclaringNodeType();
            this.name = def.getName();
            this.definesResidual = def.definesResidual();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof QPropertyDefinitionId) {
                QPropertyDefinitionId other = (QPropertyDefinitionId)obj;
                return this.declaringNodeType.equals(other.declaringNodeType) && this.name.equals(other.name) && this.definesResidual == other.definesResidual;
            }
            return false;
        }

        public int hashCode() {
            int h = 17;
            h = 37 * h + this.declaringNodeType.hashCode();
            h = 37 * h + this.name.hashCode();
            h = 37 * h + (this.definesResidual ? 11 : 43);
            return h;
        }
    }

    public class ChildNodeDefDiff
    extends ChildItemDefDiff {
        ChildNodeDefDiff(QNodeDefinition oldDef, QNodeDefinition newDef) {
            super((QItemDefinition)oldDef, (QItemDefinition)newDef);
        }

        public QNodeDefinition getOldDef() {
            return (QNodeDefinition)this.oldDef;
        }

        public QNodeDefinition getNewDef() {
            return (QNodeDefinition)this.newDef;
        }

        @Override
        protected void init() {
            super.init();
            if (this.isModified() && this.type == 1) {
                boolean b2;
                boolean b1 = this.getOldDef().allowsSameNameSiblings();
                if (b1 != (b2 = this.getNewDef().allowsSameNameSiblings()) && !b2) {
                    this.type = 2;
                }
                if (this.type == 1) {
                    HashSet<Name> s1 = new HashSet<Name>(Arrays.asList(this.getOldDef().getRequiredPrimaryTypes()));
                    HashSet<Name> s2 = new HashSet<Name>(Arrays.asList(this.getNewDef().getRequiredPrimaryTypes()));
                    s1.remove(NameConstants.NT_BASE);
                    s2.remove(NameConstants.NT_BASE);
                    if (!((Object)s1).equals(s2)) {
                        this.type = s1.containsAll(s2) ? 1 : 2;
                    }
                }
            }
        }
    }

    public class PropDefDiff
    extends ChildItemDefDiff {
        PropDefDiff(QPropertyDefinition oldDef, QPropertyDefinition newDef) {
            super((QItemDefinition)oldDef, (QItemDefinition)newDef);
        }

        public QPropertyDefinition getOldDef() {
            return (QPropertyDefinition)this.oldDef;
        }

        public QPropertyDefinition getNewDef() {
            return (QPropertyDefinition)this.newDef;
        }

        @Override
        protected void init() {
            super.init();
            if (this.isModified() && this.type == 1) {
                QValueConstraint[] vca1 = this.getOldDef().getValueConstraints();
                HashSet<String> set1 = new HashSet<String>();
                for (QValueConstraint aVca1 : vca1) {
                    set1.add(aVca1.getString());
                }
                QValueConstraint[] vca2 = this.getNewDef().getValueConstraints();
                HashSet<String> set2 = new HashSet<String>();
                for (QValueConstraint aVca2 : vca2) {
                    set2.add(aVca2.getString());
                }
                if (!((Object)set1).equals(set2)) {
                    this.type = set2.isEmpty() ? 1 : (set1.isEmpty() ? 2 : (set2.containsAll(set1) ? 1 : 2));
                }
                if (this.type == 1) {
                    boolean b2;
                    boolean b1;
                    int t2;
                    int t1 = this.getOldDef().getRequiredType();
                    if (t1 != (t2 = this.getNewDef().getRequiredType())) {
                        this.type = t2 == 0 ? 1 : 2;
                    }
                    if ((b1 = this.getOldDef().isMultiple()) != (b2 = this.getNewDef().isMultiple())) {
                        this.type = b2 ? 1 : 2;
                    }
                }
            }
        }
    }

    abstract class ChildItemDefDiff {
        protected final QItemDefinition oldDef;
        protected final QItemDefinition newDef;
        protected int type;

        ChildItemDefDiff(QItemDefinition oldDef, QItemDefinition newDef) {
            this.oldDef = oldDef;
            this.newDef = newDef;
            this.init();
        }

        protected void init() {
            this.type = this.isAdded() ? (!this.newDef.isMandatory() ? 1 : 2) : (this.isRemoved() ? 2 : (this.oldDef.equals(this.newDef) ? 0 : (this.oldDef.isMandatory() != this.newDef.isMandatory() && this.newDef.isMandatory() ? 2 : (!this.oldDef.definesResidual() && this.newDef.definesResidual() ? 1 : (!this.oldDef.getName().equals(this.newDef.getName()) ? 2 : 1)))));
        }

        public int getType() {
            return this.type;
        }

        public boolean isAdded() {
            return this.oldDef == null && this.newDef != null;
        }

        public boolean isRemoved() {
            return this.oldDef != null && this.newDef == null;
        }

        public boolean isModified() {
            return this.oldDef != null && this.newDef != null && !this.oldDef.equals(this.newDef);
        }

        public String toString() {
            String typeString = NodeTypeDefDiff.this.modificationTypeToString(this.getType());
            String operationString = this.isAdded() ? "ADDED" : (this.isModified() ? "MODIFIED" : (this.isRemoved() ? "REMOVED" : "NONE"));
            QItemDefinition itemDefinition = this.oldDef != null ? this.oldDef : this.newDef;
            return this.getClass().getName() + "[itemName=" + itemDefinition.getName() + ", type=" + typeString + ", operation=" + operationString + "]";
        }
    }
}

