﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Business.Code
{
    public static class ConnectionStringHelper
    {
        public static String CurrentConnectionString
        {
            get
            {
                string tmp = ConfigurationManager.AppSettings["UseProductionDB"];
                bool UseProductionDB = false;

                if (String.IsNullOrWhiteSpace(tmp) || !bool.TryParse(tmp, out UseProductionDB))
                    UseProductionDB = false;

                if (UseProductionDB)
                    return String.Format(
                        ConfigurationManager.ConnectionStrings["WSAuthorizationEntitiesConnectionStringFormat"].ConnectionString,
                        ConfigurationManager.ConnectionStrings["WSAuthorizationEntitiesProd"].ConnectionString);
                else
                    return String.Format(
                        ConfigurationManager.ConnectionStrings["WSAuthorizationEntitiesConnectionStringFormat"].ConnectionString,
                        ConfigurationManager.ConnectionStrings["WSAuthorizationEntities"].ConnectionString);
            }
        }

        //Return connection string without Entities Framework specific format
        public static String FlatConnectionString
        {
            get
            {
                string tmp = ConfigurationManager.AppSettings["UseProductionDB"];
                bool UseProductionDB = false;

                if (String.IsNullOrWhiteSpace(tmp) || !bool.TryParse(tmp, out UseProductionDB))
                    UseProductionDB = false;

                if (UseProductionDB)
                    return ConfigurationManager.ConnectionStrings["EntitiesDataAccessProd"].ConnectionString;
                else
                    return ConfigurationManager.ConnectionStrings["EntitiesDataAccessDev"].ConnectionString;
            }
        }
    }
}
