﻿using Sapo.ApplicationBlocks.WSAuthorization.Core.Code;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Business.DAO
{
    public class DAOApplication : DAOBase
    {
        #region Constructor
        public DAOApplication() : base() { }
        public DAOApplication(WSAuthorizationEntities externalContext) : base(externalContext) { }
        #endregion

        #region Read

        public Application Get(int idApplication)
        {
            return DBContext.Applications.Where(x => x.IdApplication == idApplication).FirstOrDefault();
        }

        public Application GetByNameUsingAppConfig()
        {
            string appName = Config.GetString("WSAuthorization::AppName");
            return DBContext.Applications.SingleOrDefault(x => x.Name == appName);
        }

        public IQueryable<Application> ListAsQueryable()
        {
            return DBContext.Applications;
        }

        public List<Application> List()
        {
            return ListAsQueryable().ToList();
        }

        #endregion
    }
}
