﻿using Sapo.ApplicationBlocks.WSAuthorization.Core.Business.Code;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Business.DAO
{
    public abstract class DAOBase
    {
        public DAOBase()
            : this(GetContext())
        {
        }

        public DAOBase(WSAuthorizationEntities DBContext)
        {
            if (DBContext == null)
            {
                this.DBContext = GetContext();
            }
            else
            {
                this.DBContext = DBContext;
            }
        }

        protected WSAuthorizationEntities DBContext { get; set; }

        //[Obsolete("Don't use this method. Create your own Method to encapsulate the Submit Changes to DataBase", false)]
        //public void SaveChanges()
        //{
        //    DBContext.SaveChanges();
        //}

        public static WSAuthorizationEntities GetContext()
        {
			//var startStatsDateTime = DateTime.Now;

			//var str = ConnectionStringHelper.CurrentConnectionString;
			//var diff = DateTime.Now.Subtract(startStatsDateTime);

			//startStatsDateTime = DateTime.Now;
			//var ctx = new WSAuthorizationEntities(str);
			//diff = DateTime.Now.Subtract(startStatsDateTime);
			//return ctx;

			return new WSAuthorizationEntities(ConnectionStringHelper.CurrentConnectionString);
        }

        public WSAuthorizationEntities GetCurrentContext()
        {
            return this.DBContext;
        }
    }
}
