﻿using Sapo.ApplicationBlocks.WSAuthorization.Core.Code;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Business.DAO
{
	public class DAOResource : DAOBase
	{
		#region Constructor

		public DAOResource() : base() { }
		public DAOResource(WSAuthorizationEntities externalContext) : base(externalContext) { }

		#endregion

		#region Read

		public Resource Get(int idResource)
		{
			return DBContext.Resources
				.Where(x => x.IdResource == idResource)
				.FirstOrDefault();
		}

		public Resource GetByName(string resourceName, string serviceName, string appName)
		{
			return DBContext.Resources
				.Where(x => x.Service.Application.Name == appName)
				.Where(x => x.Service.Name == serviceName)
				.Where(x => x.Name == resourceName)
				.FirstOrDefault();
		}

		public IQueryable<Resource> ListAsQueryable()
		{
			return DBContext.Resources;
		}

		public List<Resource> List()
		{
			return ListAsQueryable().ToList();
		}

		#endregion


	}
}
