﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Business.DAO
{
	public class DAOResourceAdditionalData:DAOBase
	{
		#region Constructor

		public DAOResourceAdditionalData() : base() { }
		public DAOResourceAdditionalData(WSAuthorizationEntities externalContext) : base(externalContext) { }

		#endregion

		public List<ResourceAdditionalData> ListForResource(string username, string resourceName, string serviceName, string appName)
		{
			return DBContext.ResourceAdditionalDatas
				.Where(x=>x.ServiceUser.Username == username)
				.Where(x => x.Resource.Name== resourceName)
				.Where(x => x.Resource.Service.Name == serviceName)
				.Where(x => x.Resource.Service.Application.Name == appName)
				.ToList();
		}
	}
}
