﻿using Sapo.ApplicationBlocks.WSAuthorization.Core.Code;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Business.DAO
{
    public class DAOService : DAOBase
    {
        #region Constructor
        public DAOService() : base() { }
        public DAOService(WSAuthorizationEntities externalContext) : base(externalContext) { }
        #endregion

        #region Read

        public Service Get(int idService)
        {
            return DBContext.Services.Where(x => x.IdService == idService).FirstOrDefault();
        }

        public Service GetByNameUsingAppConfig(string ressource)
        {
            string appName = Config.GetString("WSAuthorization::AppName");
            return DBContext.Services.Where(x => x.Name == appName).FirstOrDefault();
        }

        public IQueryable<Service> ListAsQueryable()
        {
            return DBContext.Services;
        }

        public List<Service> List()
        {
            return ListAsQueryable().ToList();
        }
        #endregion
    }
}
