﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Business.DAO
{
    public class DAOServiceUser: DAOBase
    {
        #region Constructor
        public DAOServiceUser() : base() { }
        public DAOServiceUser(WSAuthorizationEntities externalContext) : base(externalContext) { }
        #endregion

        #region Read

        public ServiceUser Get(int idServiceUser)
        {
            return DBContext.ServiceUsers.Where(x => x.IdUser == idServiceUser).FirstOrDefault();
        }

        public IQueryable<ServiceUser> ListAsQueryable()
        {
            return DBContext.ServiceUsers;
        }

        public List<ServiceUser> List()
        {
            return ListAsQueryable().ToList();
        }

        #endregion
    }
}
