﻿using Sapo.ApplicationBlocks.WSAuthorization.Core.Business.DAO;
using Sapo.ApplicationBlocks.WSAuthorization.Core.Code;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using System.Threading.Tasks;
using Sapo.ApplicationBlocks.ExecutionLog;
using System.Configuration;
using System.Data.SqlClient;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Business.Operations
{
    public class OperationsAccessControl
    {
        private static OperationsAccessControl instance;

        private static object mon = new object();

        public static OperationsAccessControl Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (mon)
                    {
                        if (instance == null)
                        {
                            instance = new OperationsAccessControl();
                        }
                    }
                }
                return instance;
            }
        }

        private ExecutionLog.ExecutionLog _logger = null;
        public ExecutionLog.ExecutionLog logger
        {
            get
            {
                //if (_logger == null)
                //{
                //	lock (mon)
                //	{
                //		if (_logger == null)
                //		{
                //			_logger = new ExecutionLog.ExecutionLog(Config.GetString("WSAuthorization::LogFile") + ESBTraceId + ".txt");
                //		}
                //	}
                //}
                //return _logger;
                return new ExecutionLog.ExecutionLog(Config.GetString("WSAuthorization::LogFile") + ESBTraceId + ".txt");
            }
        }
        
        public string ESBTraceId
        {
            get
            {
                try
                {
                    return new WebOperationContext(OperationContext.Current).IncomingRequest.Headers["ESBTraceId"];
                }
                catch (Exception)
                {
                    return string.Empty;
                }
            }
        }


        public bool HasPermissions(string username, string resourceName, string serviceName, string appName)
        {
            DAOResource daoRessource = new DAOResource();

            if (!String.IsNullOrWhiteSpace(Config.GetString("WSAuthorization::LogFile")))
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendLine();
                sb.Append("##### BEFORE BD GETRESOURCE #####")
                .Append(" Username: " + username)
                .Append(" ResourceName: " + resourceName)
                .Append(" ServiceName: " + serviceName)
                .Append(" AppName: " + appName);

                logger.Log(sb.ToString());
            }

            Resource r = daoRessource.GetByName(resourceName, serviceName, appName);

            if (!String.IsNullOrWhiteSpace(Config.GetString("WSAuthorization::LogFile")))
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendLine();
                sb.Append("##### AFTER BD GETRESOURCE #####")
                .Append(" Username: " + username)
                .Append(" ResourceName: " + resourceName)
                .Append(" ServiceName: " + serviceName)
                .Append(" AppName: " + appName);

                logger.Log(sb.ToString());
            }

            // se o recurso não existir
            if (r == null)
                return false;

            // se o recurso negar acesso a todos os users
            if (r.DenyAllUsers)
                return false;

            // se o recurso autorizar todos os Users e o utilizador existir para a aplicação em questão
            if (r.AllowAllUsers && r.Service.Application.ServiceUsers.Any(x => x.Username == username && !x.IsBlocked))
                return true;



            if (!String.IsNullOrWhiteSpace(Config.GetString("WSAuthorization::LogFile")))
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendLine();
                sb.Append("##### AFTER BD GET SERVICEUSERS #####")
                .Append(" Username: " + username)
                .Append(" ResourceName: " + resourceName)
                .Append(" ServiceName: " + serviceName)
                .Append(" AppName: " + appName);

                //File.AppendAllText(Config.GetString("WSAuthorization::LogFile").Replace(".txt", ESBTraceId + ".txt"), sb.ToString());
                logger.Log(sb.ToString());
            }

            bool userExists = r.ServiceUsers.Any(x => x.Username == username && !x.IsBlocked);

            if (!String.IsNullOrWhiteSpace(Config.GetString("WSAuthorization::LogFile")))
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendLine();
                sb.Append("##### AFTER BD GET SERVICEUSERS #####")
                .Append(" Username: " + username)
                .Append(" ResourceName: " + resourceName)
                .Append(" ServiceName: " + serviceName)
                .Append(" AppName: " + appName);

                //File.AppendAllText(Config.GetString("WSAuthorization::LogFile").Replace(".txt", ESBTraceId + ".txt"), sb.ToString());
                logger.Log(sb.ToString());
            }

            return userExists;
        }
    }
}
