﻿using Sapo.ApplicationBlocks.WSAuthorization.Core.Business.DAO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Business.Operations
{
	public class OperationsAddicionalData
	{
		private static OperationsAddicionalData instance;

		private static object lockerObject = new object();

		public static OperationsAddicionalData Instance
		{
			get
			{
				if (instance == null)
				{
					lock (lockerObject)
					{
						if (instance == null)
						{
							instance = new OperationsAddicionalData();
						}
					}
				}
				return instance;
			}
		}

		public Dictionary<string, string> GetAdditionalData(string username, string resourceName, string serviceName, string appName)
		{
			DAOResourceAdditionalData daoRessourceAdditionalData = new DAOResourceAdditionalData();
			List<ResourceAdditionalData> rawAddicionalDataRessource = daoRessourceAdditionalData.ListForResource(username, resourceName, serviceName, appName);

			DAOServiceUserAdditionalData daoServiceUserAdditionalData = new DAOServiceUserAdditionalData();
			List<ServiceUserAdditionalData> rawAddicionalDataService = daoServiceUserAdditionalData.ListForserviceName(username, serviceName);

			Dictionary<string, string> returnValues = new Dictionary<string, string>();
			if (rawAddicionalDataRessource != null)
			{
				foreach (ResourceAdditionalData data in rawAddicionalDataRessource)
				{
					returnValues.Add(data.Key, data.Value);
				}
			}

			if (rawAddicionalDataService != null)
			{
				foreach (ServiceUserAdditionalData data in rawAddicionalDataService)
				{
					returnValues.Add(data.Key, data.Value);
				}
			}

			return returnValues;
		}
	}
}
