﻿using Sapo.ApplicationBlocks.WSAuthorization.Core.Business.Operations;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;
using System.Text.RegularExpressions;
using System.ServiceModel.Web;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Code
{
	public class BUSServiceBase : ServiceBase
	{
		#region Fields
		public string AuthorizationHeaderNameSpace { get; set; }
		public string AuthorizationHeaderName { get; set; }

		private BUSCredentials _busCredentials;
		public BUSCredentials BUSCredentials
		{
			get
			{
				if (_busCredentials == null)
				{
					_busCredentials = GetTokenFromHeader();
				}
				return _busCredentials;
			}
			set { _busCredentials = value; }
		}


		private string _username = null;
		public override string Username
		{
			get
			{
				if (string.IsNullOrWhiteSpace(_username))
				{
					_username = BUSCredentials.ClientAppId;
				}
				return _username;
			}
			set
			{
				_username = value;
			}
		}

		private string _resourceName = null;
		public override string ResourceName
		{
			get
			{
				if (string.IsNullOrWhiteSpace(_resourceName))
				{
					_resourceName = GetMethodNameFormStack();
				}
				return _resourceName;
			}
			set
			{
				_resourceName = value;
			}
		}


		#endregion

		#region ctor

		public BUSServiceBase()
			: base()
		{
			AuthorizationHeaderNameSpace = Config.GetString("WSAuthorization::HeaderNameSpace");
			AuthorizationHeaderName = Config.GetString("WSAuthorization::HeaderName");
		}

		public BUSServiceBase(string authorizationHeaderNameSpace, string authorizationHeaderName)
		{
			AuthorizationHeaderNameSpace = authorizationHeaderNameSpace;
			AuthorizationHeaderName = authorizationHeaderName;
		}

		#endregion

		#region Methods

		protected BUSCredentials GetTokenFromHeader()
		{
			int headerLocation = OperationContext.Current.IncomingMessageHeaders.FindHeader(AuthorizationHeaderName, AuthorizationHeaderNameSpace);

			if (headerLocation >= 0)
			{
				BUSCredentials creadentialsHeader = OperationContext.Current.IncomingMessageHeaders.GetHeader<BUSCredentials>(headerLocation);

				if (creadentialsHeader != null)
				{
					return creadentialsHeader;
				}
			}
			else
			{
				var authorizationHeader = new WebOperationContext(OperationContext.Current).IncomingRequest.Headers["Authorization"];

				if (!string.IsNullOrWhiteSpace(authorizationHeader))
				{
					Regex regClientAppId = new Regex("ClientAppId=\"(?<clientAppId>.[^\"]*)\"");
					
					BUSCredentials creadentialsHeader = new BUSCredentials(
							regClientAppId.Match(authorizationHeader).Groups["clientAppId"].Value
						);

					return creadentialsHeader;
				}
			}
			throw new FaultException("User not authenticated.");
		}

		#endregion
	}

	[DataContract(Namespace = "http://services.sapo.pt/definitions")]
	public class BUSCredentials
	{
		public BUSCredentials(string clientAppId)
		{
			this.ClientAppId = clientAppId;
		}

		[DataMember(Order = 1, IsRequired = true)]
		public String ClientAppId { get; set; }
	}
}
