﻿using Sapo.ApplicationBlocks.WSAuthorization.Core.Business.Operations;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;
using System.Text.RegularExpressions;
using System.ServiceModel.Web;
using System.Web;
using System.Web.Http;


namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Code.Rest 
{
    public class BUSServiceBaseRest : ServiceBase 
    {
        #region Fields
        public string AuthorizationHeaderName { get; set; }

        private BUSCredentials _busCredentials;
        public BUSCredentials BUSCredentials
        {
            get
            {
                if (_busCredentials == null)
                {
                    _busCredentials = GetTokenFromHeader();
                }
                return _busCredentials;
            }
            set { _busCredentials = value; }
        }


        private string _username = null;
        public override string Username
        {
            get
            {
                if (string.IsNullOrWhiteSpace(_username))
                {
                    _username = BUSCredentials.ClientAppId;
                }
                return _username;
            }
            set
            {
                _username = value;
            }
        }

        private string _resourceName = null;
        public override string ResourceName
        {
            get
            {
                if (string.IsNullOrWhiteSpace(_resourceName))
                {
                    _resourceName = GetMethodNameFormStack();
                }
                return _resourceName;
            }
            set
            {
                _resourceName = value;
            }
        }

        #endregion Fields

        #region ctor

        public BUSServiceBaseRest() : base()
        {
            AuthorizationHeaderName = Config.GetString("WSAuthorization::HeaderName");
        }

        public BUSServiceBaseRest(string authorizationHeaderName)
        {
            AuthorizationHeaderName = authorizationHeaderName;
        }

        #endregion ctor

        #region Methods

        protected BUSCredentials GetTokenFromHeader()
        {
            HttpContext ctx = HttpContext.Current;

            string headerValue = ctx.Request.Headers[AuthorizationHeaderName];

			if (!string.IsNullOrWhiteSpace(headerValue))
			{
				Regex regClientAppId = new Regex("ClientAppId=\"(?<clientAppId>.[^\"]*)\"");

				BUSCredentials creadentialsHeader = new BUSCredentials(
						regClientAppId.Match(headerValue).Groups["clientAppId"].Value
					);

				return creadentialsHeader;
			}
			else
			{
				throw new HttpResponseException(new System.Net.Http.HttpResponseMessage(System.Net.HttpStatusCode.Unauthorized));
			}
        }

        #endregion Methods

    }

    [DataContract(Namespace = "http://services.sapo.pt/definitions")]
    public class BUSCredentials
    {
        public BUSCredentials(string clientAppId)
        {
            this.ClientAppId = clientAppId;
        }

        [DataMember(Order = 1, IsRequired = true)]
        public String ClientAppId { get; set; }
    }

}
