﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Code
{
    public class Config
    {
        public static int
		ConvertToint(String number, int errorResult)
		{
			int result = 0;

			if (!int.TryParse(number, out result))
				return errorResult;
			else
				return result;
		}

		public static
		Boolean ConvertToBoolean(String value)
		{
			Boolean result = false;

			if (!Boolean.TryParse(value, out result))
				return false;
			else
				return result;
		}

		public static
		Decimal ConvertToDecimal(String value)
		{
			Decimal result = 0;

			if (!Decimal.TryParse(value, out result))
				return 0;
			else
				return result;
		}

		public static string GetString(string key)
		{
			return ConfigurationManager.AppSettings[key];
		}

		public static Decimal? GetDecimal(string key)
		{
			Decimal result;

			if (Decimal.TryParse(GetString(key), out result))
				return result;
			return null;
		}

		public static int? GetInt(string key)
		{
			int result;

			if (int.TryParse(GetString(key), out result))
				return result;
			return null;
		}
		
		public static bool GetBoolean(string key)
		{
			bool result;

			if (bool.TryParse(GetString(key), out result))
				return result;
			
			return false;
		}

		public static TimeSpan? GetTimeSpan(string key)
		{
			TimeSpan result;

			if (TimeSpan.TryParse(GetString(key), out result))
				return result;
			return null;
		}
    }
}
