﻿using Sapo.ApplicationBlocks.WSAuthorization.Core.Business.Operations;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace Sapo.ApplicationBlocks.WSAuthorization.Core.Code
{
    public interface IServiceBase 
    {
        string Username { get; set; }
        string ResourceName { get; set; }

        bool HasPermissions();

        Dictionary<string, string> GetAdditionalData();


    }

    public abstract class ServiceBase : IServiceBase
    {

        #region Fields

        private static object objectLocker;

        private string _serviceName;
        public string ServiceName
        {
            get
            {
                if (_serviceName == null)
                {
                    lock (objectLocker)
                    {
                        if (_serviceName == null)
                        {
                            AlternateNameAttribute attr = GetAttribute<AlternateNameAttribute>(this.GetType());
                            if (attr != null && !string.IsNullOrWhiteSpace(attr.Name))
                                _serviceName = attr.Name;
                            else
                                _serviceName = this.GetType().Name;
                        }
                    }
                }
                return _serviceName;
            }
        }

        private string _appName;
        public string AppName
        {
            get
            {
                if (_appName == null)
                {
                    lock (objectLocker)
                    {
                        if (_appName == null)
                            _appName = Config.GetString("WSAuthorization::AppName");
                    }
                }
                return _appName;
            }
        }

        public abstract string Username { get; set; }
        public abstract string ResourceName { get; set; }

        #endregion

        #region ctor

        public ServiceBase()
        {
            objectLocker = new object();
        }

        #endregion

        #region Methods

        public virtual bool HasPermissions()
        {
            if (!String.IsNullOrWhiteSpace(Config.GetString("WSAuthorization::LogFile")))
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendLine();
                sb.Append("##### BEGIN REQUEST #####")
                .Append(" Username: " + Username)
                .Append(" ResourceName: " + ResourceName)
                .Append(" ServiceName: " + ServiceName)
                .Append(" AppName: " + AppName);

                OperationsAccessControl.Instance.logger.Log(sb.ToString());
            }

            bool result = OperationsAccessControl.Instance.HasPermissions(Username, ResourceName, ServiceName, AppName);

            if (!String.IsNullOrWhiteSpace(Config.GetString("WSAuthorization::LogFile")))
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendLine();
                sb.Append("##### END REQUEST #####")
                .Append(" Username: " + Username)
                .Append(" ResourceName: " + ResourceName)
                .Append(" ServiceName: " + ServiceName)
                .Append(" AppName: " + AppName)
                .Append(" RESULT: " + result);

                OperationsAccessControl.Instance.logger.Log(sb.ToString());
            }

            return result;
        }

        public Dictionary<string,string> GetAdditionalData()
        {
            return OperationsAddicionalData.Instance.GetAdditionalData(Username, ResourceName, ServiceName, AppName);
        }

        #endregion

        #region Helpers

        protected string GetMethodNameFormStack(int stackTraceLevelIndex=3)
        {
            StackTrace stackTrace = new StackTrace();
            MethodBase methodBase = stackTrace.GetFrame(stackTraceLevelIndex).GetMethod();
            return methodBase.Name;
        }

        protected static ATTR GetAttribute<ATTR>(Type t) where ATTR : Attribute
        {
            ATTR attr = (ATTR)Attribute.GetCustomAttribute(t, typeof(ATTR));
            return attr;
        }

        #endregion

    }

    [AttributeUsage(AttributeTargets.All, AllowMultiple = false, Inherited = false)]
    public class AlternateNameAttribute : Attribute
    {
        public string Name { get; set; }
    }
}
