/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.ByteStreams;
import com.google.cloud.dataflow.sdk.util.ExposedByteArrayOutputStream;
import com.google.cloud.dataflow.sdk.util.StreamUtils;
import com.google.cloud.dataflow.sdk.util.VarInt;
import com.google.cloud.dataflow.sdk.util.common.worker.PartialGroupByKeyOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayCoder
extends AtomicCoder<byte[]> {
    private static final ByteArrayCoder INSTANCE = new ByteArrayCoder();

    @JsonCreator
    public static ByteArrayCoder of() {
        return INSTANCE;
    }

    private ByteArrayCoder() {
    }

    @Override
    public void encode(byte[] value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null byte[]");
        }
        if (!context.isWholeStream) {
            VarInt.encode(value.length, outStream);
            outStream.write(value);
        } else {
            outStream.write(value);
        }
    }

    public void encodeAndOwn(byte[] value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (!context.isWholeStream) {
            VarInt.encode(value.length, outStream);
            outStream.write(value);
        } else if (outStream instanceof ExposedByteArrayOutputStream) {
            ((ExposedByteArrayOutputStream)outStream).writeAndOwn(value);
        } else {
            outStream.write(value);
        }
    }

    @Override
    public byte[] decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        if (context.isWholeStream) {
            return StreamUtils.getBytes(inStream);
        }
        int length = VarInt.decodeInt(inStream);
        if (length < 0) {
            throw new IOException(new StringBuilder(26).append("invalid length ").append(length).toString());
        }
        byte[] value = new byte[length];
        ByteStreams.readFully(inStream, value);
        return value;
    }

    @Override
    public Object structuralValue(byte[] value) {
        return new PartialGroupByKeyOperation.StructuralByteArray(value);
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(byte[] value, Coder.Context context) {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(byte[] value, Coder.Context context) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null byte[]");
        }
        long size = 0L;
        if (!context.isWholeStream) {
            size += (long)VarInt.getLength(value.length);
        }
        return size + (long)value.length;
    }
}

