/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.CustomCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class DelegateCoder<T, IntermediateT>
extends CustomCoder<T> {
    private final Coder<IntermediateT> coder;
    private final CodingFunction<T, IntermediateT> toFn;
    private final CodingFunction<IntermediateT, T> fromFn;

    public static <T, IntermediateT> DelegateCoder<T, IntermediateT> of(Coder<IntermediateT> coder, CodingFunction<T, IntermediateT> toFn, CodingFunction<IntermediateT, T> fromFn) {
        return new DelegateCoder<T, IntermediateT>(coder, toFn, fromFn);
    }

    @Override
    public void encode(T value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        this.coder.encode(this.applyAndWrapExceptions(this.toFn, value), outStream, context);
    }

    @Override
    public T decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        return this.applyAndWrapExceptions(this.fromFn, this.coder.decode(inStream, context));
    }

    public Coder<IntermediateT> getCoder() {
        return this.coder;
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.coder.verifyDeterministic();
    }

    @Override
    public Object structuralValue(T value) throws Exception {
        return this.coder.structuralValue(this.toFn.apply(value));
    }

    @Override
    public String toString() {
        String string = String.valueOf(this.coder);
        return new StringBuilder(15 + String.valueOf(string).length()).append("DelegateCoder(").append(string).append(")").toString();
    }

    @Override
    public String getEncodingId() {
        return this.delegateEncodingId(this.coder.getClass(), this.coder.getEncodingId());
    }

    @Override
    public Collection<String> getAllowedEncodings() {
        ArrayList<String> allowedEncodings = Lists.newArrayList();
        for (String allowedEncoding : this.coder.getAllowedEncodings()) {
            allowedEncodings.add(this.delegateEncodingId(this.coder.getClass(), allowedEncoding));
        }
        return allowedEncodings;
    }

    private String delegateEncodingId(Class<?> delegateClass, String encodingId) {
        return String.format("%s:%s", delegateClass.getName(), encodingId);
    }

    private <InputT, OutputT> OutputT applyAndWrapExceptions(CodingFunction<InputT, OutputT> fn, InputT input) throws CoderException, IOException {
        try {
            return fn.apply(input);
        }
        catch (IOException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new CoderException(exc);
        }
    }

    protected DelegateCoder(Coder<IntermediateT> coder, CodingFunction<T, IntermediateT> toFn, CodingFunction<IntermediateT, T> fromFn) {
        this.coder = coder;
        this.fromFn = fromFn;
        this.toFn = toFn;
    }

    public static interface CodingFunction<InputT, OutputT>
    extends Serializable {
        public OutputT apply(InputT var1) throws Exception;
    }
}

