/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.BigEndianLongCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Converter;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.joda.time.Instant;

public class InstantCoder
extends AtomicCoder<Instant> {
    private static final InstantCoder INSTANCE = new InstantCoder();
    private final Coder<Long> longCoder = BigEndianLongCoder.of();
    private static final Converter<Instant, Long> ORDER_PRESERVING_CONVERTER = new Converter<Instant, Long>(){

        @Override
        protected Long doForward(Instant instant) {
            return instant.getMillis() - Long.MIN_VALUE;
        }

        @Override
        protected Instant doBackward(Long shiftedMillis) {
            return new Instant(shiftedMillis + Long.MIN_VALUE);
        }
    };

    @JsonCreator
    public static InstantCoder of() {
        return INSTANCE;
    }

    private InstantCoder() {
    }

    @Override
    public void encode(Instant value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null Instant");
        }
        this.longCoder.encode(ORDER_PRESERVING_CONVERTER.convert(value), outStream, context);
    }

    @Override
    public Instant decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        return ORDER_PRESERVING_CONVERTER.reverse().convert(this.longCoder.decode(inStream, context));
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Instant value, Coder.Context context) {
        return this.longCoder.isRegisterByteSizeObserverCheap(ORDER_PRESERVING_CONVERTER.convert(value), context);
    }

    @Override
    public void registerByteSizeObserver(Instant value, ElementByteSizeObserver observer, Coder.Context context) throws Exception {
        this.longCoder.registerByteSizeObserver(ORDER_PRESERVING_CONVERTER.convert(value), observer, context);
    }
}

