/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Optional;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;

public class NullableCoder<T>
extends StandardCoder<T> {
    private final Coder<T> valueCoder;
    private static final int ENCODE_NULL = 0;
    private static final int ENCODE_PRESENT = 1;

    public static <T> NullableCoder<T> of(Coder<T> valueCoder) {
        return new NullableCoder<T>(valueCoder);
    }

    @JsonCreator
    public static NullableCoder<?> of(@JsonProperty(value="component_encodings") List<Coder<?>> components) {
        int n = components.size();
        Preconditions.checkArgument(components.size() == 1, new StringBuilder(39).append("Expecting 1 components, got ").append(n).toString());
        return NullableCoder.of(components.get(0));
    }

    private NullableCoder(Coder<T> valueCoder) {
        this.valueCoder = valueCoder;
    }

    @Override
    public void encode(@Nullable T value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            outStream.write(0);
        } else {
            outStream.write(1);
            this.valueCoder.encode(value, outStream, context.nested());
        }
    }

    @Override
    @Nullable
    public T decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        int b = inStream.read();
        if (b == 0) {
            return null;
        }
        if (b != 1) {
            throw new CoderException(String.format("NullableCoder expects either a byte valued %s (null) or %s (present), got %s", 0, 1, b));
        }
        return this.valueCoder.decode(inStream, context.nested());
    }

    @Override
    public List<Coder<T>> getCoderArguments() {
        return ImmutableList.of(this.valueCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.verifyDeterministic("Value coder must be deterministic", this.valueCoder);
    }

    @Override
    public boolean consistentWithEquals() {
        return this.valueCoder.consistentWithEquals();
    }

    @Override
    public Object structuralValue(@Nullable T value) throws Exception {
        if (value == null) {
            return Optional.absent();
        }
        return Optional.of(this.valueCoder.structuralValue(value));
    }

    @Override
    public void registerByteSizeObserver(@Nullable T value, ElementByteSizeObserver observer, Coder.Context context) throws Exception {
        observer.update(1);
        if (value != null) {
            this.valueCoder.registerByteSizeObserver(value, observer, context.nested());
        }
    }

    @Override
    protected long getEncodedElementByteSize(@Nullable T value, Coder.Context context) throws Exception {
        if (value == null) {
            return 1L;
        }
        if (this.valueCoder instanceof StandardCoder) {
            return 1L + ((StandardCoder)this.valueCoder).getEncodedElementByteSize(value, context.nested());
        }
        return super.getEncodedElementByteSize(value, context);
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(@Nullable T value, Coder.Context context) {
        return this.valueCoder.isRegisterByteSizeObserverCheap(value, context.nested());
    }
}

