/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Sets;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class Proto2Coder<T extends Message>
extends AtomicCoder<T> {
    private final Class<T> protoMessageClass;
    private final List<Class<?>> extensionHostClasses;
    private transient Parser<T> memoizedParser;
    private transient ExtensionRegistry memoizedExtensionRegistry;
    private static final String PROTO_MESSAGE_CLASS = "proto_message_class";
    private static final String PROTO_EXTENSION_HOSTS = "proto_extension_hosts";

    private Proto2Coder(Class<T> protoMessageClass, List<Class<?>> extensionHostClasses) {
        this.protoMessageClass = protoMessageClass;
        this.extensionHostClasses = extensionHostClasses;
    }

    public static <T extends Message> Proto2Coder<T> of(Class<T> protoMessageClass) {
        return new Proto2Coder<T>(protoMessageClass, Collections.emptyList());
    }

    public Proto2Coder<T> withExtensionsFrom(Iterable<Class<?>> moreExtensionHosts) {
        for (Class<?> extensionHost : moreExtensionHosts) {
            try {
                Method registerAllExtensions = extensionHost.getDeclaredMethod("registerAllExtensions", ExtensionRegistry.class);
                Preconditions.checkArgument(0 != (registerAllExtensions.getModifiers() | 8), "Method registerAllExtensions() must be static for use with Proto2Coder");
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return new Proto2Coder<T>(this.protoMessageClass, (List<Class<?>>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.extensionHostClasses)).addAll(moreExtensionHosts)).build()));
    }

    public Proto2Coder<T> withExtensionsFrom(Class<?> ... extensionHosts) {
        return this.withExtensionsFrom(ImmutableList.copyOf(extensionHosts));
    }

    @Deprecated
    public Proto2Coder<T> addExtensionsFrom(Class<?> ... extensionHosts) {
        return this.addExtensionsFrom(ImmutableList.copyOf(extensionHosts));
    }

    @Deprecated
    public Proto2Coder<T> addExtensionsFrom(Iterable<Class<?>> extensionHosts) {
        for (Class<?> extensionHost : extensionHosts) {
            try {
                extensionHost.getDeclaredMethod("registerAllExtensions", ExtensionRegistry.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            this.extensionHostClasses.add(extensionHost);
        }
        return this;
    }

    @Override
    public void encode(T value, OutputStream outStream, Coder.Context context) throws IOException {
        if (value == null) {
            String string = String.valueOf(this.protoMessageClass.getSimpleName());
            throw new CoderException(string.length() != 0 ? "cannot encode a null ".concat(string) : new String("cannot encode a null "));
        }
        if (context.isWholeStream) {
            value.writeTo(outStream);
        } else {
            value.writeDelimitedTo(outStream);
        }
    }

    @Override
    public T decode(InputStream inStream, Coder.Context context) throws IOException {
        if (context.isWholeStream) {
            return (T)((Message)this.getParser().parseFrom(inStream, (ExtensionRegistryLite)this.getExtensionRegistry()));
        }
        return (T)((Message)this.getParser().parseDelimitedFrom(inStream, (ExtensionRegistryLite)this.getExtensionRegistry()));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Proto2Coder)) {
            return false;
        }
        Proto2Coder otherCoder = (Proto2Coder)other;
        return this.protoMessageClass.equals(otherCoder.protoMessageClass) && Sets.newHashSet(this.extensionHostClasses).equals(Sets.newHashSet(otherCoder.extensionHostClasses));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.protoMessageClass, this.extensionHostClasses);
    }

    @Override
    public String getEncodingId() {
        return this.protoMessageClass.getName();
    }

    private Parser<T> getParser() {
        if (this.memoizedParser == null) {
            try {
                Parser tParser;
                Message protoMessageInstance = (Message)this.protoMessageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
                this.memoizedParser = tParser = protoMessageInstance.getParserForType();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.memoizedParser;
    }

    private ExtensionRegistry getExtensionRegistry() {
        if (this.memoizedExtensionRegistry == null) {
            this.memoizedExtensionRegistry = ExtensionRegistry.newInstance();
            for (Class<?> extensionHost : this.extensionHostClasses) {
                try {
                    extensionHost.getDeclaredMethod("registerAllExtensions", ExtensionRegistry.class).invoke(null, this.memoizedExtensionRegistry);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return this.memoizedExtensionRegistry;
    }

    @JsonCreator
    public static <T extends Message> Proto2Coder<T> of(@JsonProperty(value="proto_message_class") String protoMessageClassName, @Nullable @JsonProperty(value="proto_extension_hosts") List<String> extensionHostClassNames) {
        try {
            Class<?> protoMessageClass = Class.forName(protoMessageClassName);
            ArrayList<Class<?>> extensionHostClasses = Lists.newArrayList();
            if (extensionHostClassNames != null) {
                for (String extensionHostClassName : extensionHostClassNames) {
                    extensionHostClasses.add(Class.forName(extensionHostClassName));
                }
            }
            return Proto2Coder.of(protoMessageClass).withExtensionsFrom(extensionHostClasses);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public CloudObject asCloudObject() {
        CloudObject result = super.asCloudObject();
        Structs.addString((Map<String, Object>)((Object)result), PROTO_MESSAGE_CLASS, this.protoMessageClass.getName());
        ArrayList<CloudObject> extensionHostClassNames = Lists.newArrayList();
        for (Class<?> clazz : this.extensionHostClasses) {
            extensionHostClassNames.add(CloudObject.forString(clazz.getName()));
        }
        Structs.addList((Map<String, Object>)((Object)result), PROTO_EXTENSION_HOSTS, extensionHostClassNames);
        return result;
    }
}

