/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.StringUtf8Coder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TextualIntegerCoder
extends AtomicCoder<Integer> {
    @JsonCreator
    public static TextualIntegerCoder of() {
        return new TextualIntegerCoder();
    }

    protected TextualIntegerCoder() {
    }

    @Override
    public void encode(Integer value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        String textualValue = value.toString();
        StringUtf8Coder.of().encode(textualValue, outStream, context);
    }

    @Override
    public Integer decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        String textualValue = StringUtf8Coder.of().decode(inStream, context);
        try {
            return Integer.valueOf(textualValue);
        }
        catch (NumberFormatException exn) {
            throw new CoderException("error when decoding a textual integer", exn);
        }
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    protected long getEncodedElementByteSize(Integer value, Coder.Context context) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        String textualValue = value.toString();
        return StringUtf8Coder.of().getEncodedElementByteSize(textualValue, context);
    }
}

