/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.coders.AvroCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.runners.DirectPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.worker.AvroReader;
import com.google.cloud.dataflow.sdk.runners.worker.AvroSink;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.ReaderUtils;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.common.worker.Sink;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PDone;
import com.google.cloud.dataflow.sdk.values.PInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.ReflectData;

public class AvroIO {
    private static final Pattern SHARD_OUTPUT_PATTERN = Pattern.compile("@([0-9]+|\\*)");

    private static void validateOutputComponent(String partialFilePattern) {
        String string = String.valueOf(partialFilePattern);
        Preconditions.checkArgument(!SHARD_OUTPUT_PATTERN.matcher(partialFilePattern).find(), string.length() != 0 ? "Output name components are not allowed to contain @* or @N patterns: ".concat(string) : new String("Output name components are not allowed to contain @* or @N patterns: "));
    }

    private static <T> void evaluateReadHelper(Read.Bound<T> transform, DirectPipelineRunner.EvaluationContext context) {
        AvroReader<T> reader = new AvroReader<T>(transform.filepattern, null, null, WindowedValue.getValueOnlyCoder(transform.getDefaultOutputCoder()));
        List<WindowedValue> elems = ReaderUtils.readElemsFromReader(reader);
        ArrayList output = new ArrayList();
        for (WindowedValue elem : elems) {
            output.add(DirectPipelineRunner.ValueWithMetadata.of(elem));
        }
        context.setPCollectionValuesWithMetadata((PCollection)context.getOutput(transform), output);
    }

    private static <T> void evaluateWriteHelper(Write.Bound<T> transform, DirectPipelineRunner.EvaluationContext context) {
        List elems = context.getPCollectionWindowedValues((PCollection)context.getInput(transform));
        int numShards = transform.numShards;
        if (numShards < 1) {
            numShards = 1;
        }
        AvroSink writer = new AvroSink(transform.filenamePrefix, transform.shardTemplate, transform.filenameSuffix, numShards, WindowedValue.getValueOnlyCoder(AvroCoder.of(transform.type, transform.schema)));
        try (Sink.SinkWriter sink = writer.writer();){
            for (WindowedValue elem : elems) {
                sink.add(elem);
            }
        }
        catch (IOException exn) {
            String string = transform.filenamePrefix;
            throw new RuntimeException(new StringBuilder(33 + String.valueOf(string).length()).append("unable to write to output file \"").append(string).append("\"").toString(), exn);
        }
    }

    public static class Write {
        public static Bound<GenericRecord> named(String name) {
            return new Bound<GenericRecord>(GenericRecord.class).named(name);
        }

        public static Bound<GenericRecord> to(String prefix) {
            return new Bound<GenericRecord>(GenericRecord.class).to(prefix);
        }

        public static Bound<GenericRecord> withSuffix(String filenameSuffix) {
            return new Bound<GenericRecord>(GenericRecord.class).withSuffix(filenameSuffix);
        }

        public static Bound<GenericRecord> withNumShards(int numShards) {
            return new Bound<GenericRecord>(GenericRecord.class).withNumShards(numShards);
        }

        public static Bound<GenericRecord> withShardNameTemplate(String shardTemplate) {
            return new Bound<GenericRecord>(GenericRecord.class).withShardNameTemplate(shardTemplate);
        }

        public static Bound<GenericRecord> withoutSharding() {
            return new Bound<GenericRecord>(GenericRecord.class).withoutSharding();
        }

        public static <T> Bound<T> withSchema(Class<T> type) {
            return new Bound<T>(type).withSchema(type);
        }

        public static Bound<GenericRecord> withSchema(Schema schema) {
            return new Bound<GenericRecord>(GenericRecord.class).withSchema(schema);
        }

        public static Bound<GenericRecord> withSchema(String schema) {
            return Write.withSchema(new Schema.Parser().parse(schema));
        }

        public static Bound<GenericRecord> withoutValidation() {
            return new Bound<GenericRecord>(GenericRecord.class).withoutValidation();
        }

        public static class Bound<T>
        extends PTransform<PCollection<T>, PDone> {
            @Nullable
            final String filenamePrefix;
            final String filenameSuffix;
            final int numShards;
            final String shardTemplate;
            final Class<T> type;
            @Nullable
            final Schema schema;
            final boolean validate;

            Bound(Class<T> type) {
                this(null, null, "", 0, "-SSSSS-of-NNNNN", type, null, true);
            }

            Bound(String name, String filenamePrefix, String filenameSuffix, int numShards, String shardTemplate, Class<T> type, Schema schema, boolean validate) {
                super(name);
                this.filenamePrefix = filenamePrefix;
                this.filenameSuffix = filenameSuffix;
                this.numShards = numShards;
                this.shardTemplate = shardTemplate;
                this.type = type;
                this.schema = schema;
                this.validate = validate;
            }

            public Bound<T> named(String name) {
                return new Bound<T>(name, this.filenamePrefix, this.filenameSuffix, this.numShards, this.shardTemplate, this.type, this.schema, this.validate);
            }

            public Bound<T> to(String filenamePrefix) {
                AvroIO.validateOutputComponent(filenamePrefix);
                return new Bound<T>(this.name, filenamePrefix, this.filenameSuffix, this.numShards, this.shardTemplate, this.type, this.schema, this.validate);
            }

            public Bound<T> withSuffix(String filenameSuffix) {
                AvroIO.validateOutputComponent(filenameSuffix);
                return new Bound<T>(this.name, this.filenamePrefix, filenameSuffix, this.numShards, this.shardTemplate, this.type, this.schema, this.validate);
            }

            public Bound<T> withNumShards(int numShards) {
                Preconditions.checkArgument(numShards >= 0);
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, numShards, this.shardTemplate, this.type, this.schema, this.validate);
            }

            public Bound<T> withShardNameTemplate(String shardTemplate) {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.numShards, shardTemplate, this.type, this.schema, this.validate);
            }

            public Bound<T> withoutSharding() {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, 1, "", this.type, this.schema, this.validate);
            }

            public <X> Bound<X> withSchema(Class<X> type) {
                return new Bound<X>(this.name, this.filenamePrefix, this.filenameSuffix, this.numShards, this.shardTemplate, type, ReflectData.get().getSchema(type), this.validate);
            }

            public Bound<GenericRecord> withSchema(Schema schema) {
                return new Bound<GenericRecord>(this.name, this.filenamePrefix, this.filenameSuffix, this.numShards, this.shardTemplate, GenericRecord.class, schema, this.validate);
            }

            public Bound<GenericRecord> withSchema(String schema) {
                return this.withSchema(new Schema.Parser().parse(schema));
            }

            public Bound<T> withoutValidation() {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.numShards, this.shardTemplate, this.type, this.schema, false);
            }

            @Override
            public PDone apply(PCollection<T> input) {
                if (this.filenamePrefix == null) {
                    throw new IllegalStateException("need to set the filename prefix of an AvroIO.Write transform");
                }
                if (this.schema == null) {
                    throw new IllegalStateException("need to set the schema of an AvroIO.Write transform");
                }
                return PDone.in(input.getPipeline());
            }

            public String getShardNameTemplate() {
                return this.shardTemplate;
            }

            @Override
            protected Coder<Void> getDefaultOutputCoder() {
                return VoidCoder.of();
            }

            public String getFilenamePrefix() {
                return this.filenamePrefix;
            }

            public String getShardTemplate() {
                return this.shardTemplate;
            }

            public int getNumShards() {
                return this.numShards;
            }

            public String getFilenameSuffix() {
                return this.filenameSuffix;
            }

            public Class<T> getType() {
                return this.type;
            }

            public Schema getSchema() {
                return this.schema;
            }

            public boolean needsValidation() {
                return this.validate;
            }

            static {
                DirectPipelineRunner.TransformEvaluator<Bound> transformEvaluator = new DirectPipelineRunner.TransformEvaluator<Bound>(){

                    @Override
                    public void evaluate(Bound transform, DirectPipelineRunner.EvaluationContext context) {
                        AvroIO.evaluateWriteHelper(transform, context);
                    }
                };
                DirectPipelineRunner.registerDefaultTransformEvaluator(Bound.class, transformEvaluator);
            }
        }
    }

    public static class Read {
        public static Bound<GenericRecord> named(String name) {
            return new Bound<GenericRecord>(GenericRecord.class).named(name);
        }

        public static Bound<GenericRecord> from(String filepattern) {
            return new Bound<GenericRecord>(GenericRecord.class).from(filepattern);
        }

        public static <T> Bound<T> withSchema(Class<T> type) {
            return new Bound<T>(type).withSchema(type);
        }

        public static Bound<GenericRecord> withSchema(Schema schema) {
            return new Bound<GenericRecord>(GenericRecord.class).withSchema(schema);
        }

        public static Bound<GenericRecord> withSchema(String schema) {
            return Read.withSchema(new Schema.Parser().parse(schema));
        }

        public static Bound<GenericRecord> withoutValidation() {
            return new Bound<GenericRecord>(GenericRecord.class).withoutValidation();
        }

        public static class Bound<T>
        extends PTransform<PInput, PCollection<T>> {
            @Nullable
            final String filepattern;
            final Class<T> type;
            @Nullable
            final Schema schema;
            final boolean validate;

            Bound(Class<T> type) {
                this(null, null, type, null, true);
            }

            Bound(String name, String filepattern, Class<T> type, Schema schema, boolean validate) {
                super(name);
                this.filepattern = filepattern;
                this.type = type;
                this.schema = schema;
                this.validate = validate;
            }

            public Bound<T> named(String name) {
                return new Bound<T>(name, this.filepattern, this.type, this.schema, this.validate);
            }

            public Bound<T> from(String filepattern) {
                return new Bound<T>(this.name, filepattern, this.type, this.schema, this.validate);
            }

            public <X> Bound<X> withSchema(Class<X> type) {
                return new Bound<X>(this.name, this.filepattern, type, ReflectData.get().getSchema(type), this.validate);
            }

            public Bound<GenericRecord> withSchema(Schema schema) {
                return new Bound<GenericRecord>(this.name, this.filepattern, GenericRecord.class, schema, this.validate);
            }

            public Bound<GenericRecord> withSchema(String schema) {
                return this.withSchema(new Schema.Parser().parse(schema));
            }

            public Bound<T> withoutValidation() {
                return new Bound<T>(this.name, this.filepattern, this.type, this.schema, false);
            }

            @Override
            public PCollection<T> apply(PInput input) {
                if (this.filepattern == null) {
                    throw new IllegalStateException("need to set the filepattern of an AvroIO.Read transform");
                }
                if (this.schema == null) {
                    throw new IllegalStateException("need to set the schema of an AvroIO.Read transform");
                }
                return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.BOUNDED).setCoder((Coder)this.getDefaultOutputCoder());
            }

            @Override
            protected Coder<T> getDefaultOutputCoder() {
                return AvroCoder.of(this.type, this.schema);
            }

            public String getFilepattern() {
                return this.filepattern;
            }

            public Schema getSchema() {
                return this.schema;
            }

            public boolean needsValidation() {
                return this.validate;
            }

            static {
                DirectPipelineRunner.TransformEvaluator<Bound> transformEvaluator = new DirectPipelineRunner.TransformEvaluator<Bound>(){

                    @Override
                    public void evaluate(Bound transform, DirectPipelineRunner.EvaluationContext context) {
                        AvroIO.evaluateReadHelper(transform, context);
                    }
                };
                DirectPipelineRunner.registerDefaultTransformEvaluator(Bound.class, transformEvaluator);
            }
        }
    }
}

