/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.io.FileBasedSource;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public abstract class BlockBasedSource<T>
extends FileBasedSource<T> {
    public BlockBasedSource(String fileOrPatternSpec, long minBundleSize) {
        super(fileOrPatternSpec, minBundleSize);
    }

    public BlockBasedSource(String fileName, long minBundleSize, long startOffset, long endOffset) {
        super(fileName, minBundleSize, startOffset, endOffset);
    }

    @Override
    public abstract BlockBasedSource<T> createForSubrangeOfFile(String var1, long var2, long var4);

    @Override
    public abstract BlockBasedReader<T> createSingleFileReader(PipelineOptions var1);

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    protected static abstract class BlockBasedReader<T>
    extends FileBasedSource.FileBasedReader<T> {
        private boolean atSplitPoint;

        protected BlockBasedReader(BlockBasedSource<T> source) {
            super(source);
        }

        public abstract boolean readNextBlock() throws IOException;

        @Nullable
        public abstract Block<T> getCurrentBlock();

        public abstract long getCurrentBlockSize();

        public abstract long getCurrentBlockOffset();

        @Override
        public final T getCurrent() throws NoSuchElementException {
            Block<T> currentBlock = this.getCurrentBlock();
            if (currentBlock == null) {
                String string = String.valueOf(this.getCurrentSource());
                throw new NoSuchElementException(new StringBuilder(41 + String.valueOf(string).length()).append("No block has been successfully read from ").append(string).toString());
            }
            return currentBlock.getCurrentRecord();
        }

        @Override
        protected boolean isAtSplitPoint() {
            return this.atSplitPoint;
        }

        @Override
        protected final boolean readNextRecord() throws IOException {
            this.atSplitPoint = false;
            while (this.getCurrentBlock() == null || !this.getCurrentBlock().readNextRecord()) {
                if (!this.readNextBlock()) {
                    return false;
                }
                this.atSplitPoint = true;
            }
            return true;
        }

        @Override
        public Double getFractionConsumed() {
            if (this.getCurrentSource().getEndOffset() == Long.MAX_VALUE) {
                return null;
            }
            Block<T> currentBlock = this.getCurrentBlock();
            if (currentBlock == null) {
                return 0.0;
            }
            long currentBlockOffset = this.getCurrentBlockOffset();
            long startOffset = this.getCurrentSource().getStartOffset();
            long endOffset = this.getCurrentSource().getEndOffset();
            double fractionAtBlockStart = (double)(currentBlockOffset - startOffset) / (double)(endOffset - startOffset);
            double fractionAtBlockEnd = (double)(currentBlockOffset + this.getCurrentBlockSize() - startOffset) / (double)(endOffset - startOffset);
            return Math.min(1.0, fractionAtBlockStart + currentBlock.getFractionOfBlockConsumed() * (fractionAtBlockEnd - fractionAtBlockStart));
        }

        @Override
        protected long getCurrentOffset() {
            return this.getCurrentBlockOffset();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    protected static abstract class Block<T> {
        protected Block() {
        }

        public abstract T getCurrentRecord();

        public abstract boolean readNextRecord() throws IOException;

        public abstract double getFractionOfBlockConsumed();
    }
}

