/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.io.FileBasedSource;
import com.google.cloud.dataflow.sdk.io.Read;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.NoSuchElementException;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class CompressedSource<T>
extends FileBasedSource<T> {
    private final FileBasedSource<T> sourceDelegate;
    private final DecompressingChannelFactory channelFactory;

    public static <T> Read.Bounded<T> readFromSource(FileBasedSource<T> sourceDelegate, DecompressingChannelFactory channelFactory) {
        return Read.from(new CompressedSource<T>(sourceDelegate, channelFactory));
    }

    public static <T> CompressedSource<T> from(FileBasedSource<T> sourceDelegate) {
        return new CompressedSource<T>(sourceDelegate, null);
    }

    public CompressedSource<T> withDecompression(DecompressingChannelFactory channelFactory) {
        return new CompressedSource<T>(this.sourceDelegate, channelFactory);
    }

    private CompressedSource(FileBasedSource<T> sourceDelegate, DecompressingChannelFactory channelFactory) {
        super(sourceDelegate.getFileOrPatternSpec(), Long.MAX_VALUE);
        this.sourceDelegate = sourceDelegate;
        this.channelFactory = channelFactory;
    }

    private CompressedSource(FileBasedSource<T> sourceDelegate, DecompressingChannelFactory channelFactory, String filePatternOrSpec, long minBundleSize, long startOffset, long endOffset) {
        super(filePatternOrSpec, minBundleSize, startOffset, endOffset);
        Preconditions.checkArgument(startOffset == 0L, new StringBuilder(88).append("CompressedSources must start reading at offset 0. Requested offset: ").append(startOffset).toString());
        this.sourceDelegate = sourceDelegate;
        this.channelFactory = channelFactory;
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkNotNull(this.sourceDelegate);
        this.sourceDelegate.validate();
        Preconditions.checkNotNull(this.channelFactory);
    }

    @Override
    public CompressedSource<T> createForSubrangeOfFile(String fileName, long start, long end) {
        return new CompressedSource<T>(this.sourceDelegate.createForSubrangeOfFile(fileName, start, end), this.channelFactory, fileName, Long.MAX_VALUE, start, end);
    }

    @Override
    protected final boolean isSplittable() throws Exception {
        return false;
    }

    @Override
    public final CompressedReader<T> createSingleFileReader(PipelineOptions options) {
        return new CompressedReader<T>(this, this.sourceDelegate.createSingleFileReader(options));
    }

    @Override
    public final boolean producesSortedKeys(PipelineOptions options) throws Exception {
        return this.sourceDelegate.producesSortedKeys(options);
    }

    @Override
    public final Coder<T> getDefaultOutputCoder() {
        return this.sourceDelegate.getDefaultOutputCoder();
    }

    public final DecompressingChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public static class CompressedReader<T>
    extends FileBasedSource.FileBasedReader<T> {
        private final FileBasedSource.FileBasedReader<T> readerDelegate;
        private final CompressedSource<T> source;
        private int numRecordsRead;

        public CompressedReader(CompressedSource<T> source, FileBasedSource.FileBasedReader<T> readerDelegate) {
            super(source);
            this.source = source;
            this.readerDelegate = readerDelegate;
        }

        @Override
        public T getCurrent() throws NoSuchElementException {
            return this.readerDelegate.getCurrent();
        }

        @Override
        protected final boolean isAtSplitPoint() {
            return this.numRecordsRead == 1;
        }

        @Override
        protected final void startReading(ReadableByteChannel channel) throws IOException {
            this.readerDelegate.startReading(this.source.getChannelFactory().createDecompressingChannel(channel));
        }

        @Override
        protected final boolean readNextRecord() throws IOException {
            if (!this.readerDelegate.readNextRecord()) {
                return false;
            }
            ++this.numRecordsRead;
            return true;
        }

        @Override
        protected final long getCurrentOffset() {
            return this.readerDelegate.getCurrentOffset();
        }
    }

    public static enum CompressionMode implements DecompressingChannelFactory
    {
        GZIP{

            @Override
            public ReadableByteChannel createDecompressingChannel(ReadableByteChannel channel) throws IOException {
                return Channels.newChannel((InputStream)new GzipCompressorInputStream(Channels.newInputStream(channel)));
            }
        }
        ,
        BZIP2{

            @Override
            public ReadableByteChannel createDecompressingChannel(ReadableByteChannel channel) throws IOException {
                return Channels.newChannel((InputStream)new BZip2CompressorInputStream(Channels.newInputStream(channel)));
            }
        };


        @Override
        public abstract ReadableByteChannel createDecompressingChannel(ReadableByteChannel var1) throws IOException;
    }

    public static interface DecompressingChannelFactory
    extends Serializable {
        public ReadableByteChannel createDecompressingChannel(ReadableByteChannel var1) throws IOException;
    }
}

