/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.io.BoundedSource;
import com.google.cloud.dataflow.sdk.io.range.OffsetRangeTracker;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OffsetBasedSource<T>
extends BoundedSource<T> {
    private final long startOffset;
    private final long endOffset;
    private final long minBundleSize;

    public OffsetBasedSource(long startOffset, long endOffset, long minBundleSize) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.minBundleSize = minBundleSize;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public long getMinBundleSize() {
        return this.minBundleSize;
    }

    @Override
    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        long trueEndOffset = this.endOffset == Long.MAX_VALUE ? this.getMaxEndOffset(options) : this.endOffset;
        return this.getBytesPerOffset() * (trueEndOffset - this.getStartOffset());
    }

    @Override
    public List<? extends OffsetBasedSource<T>> splitIntoBundles(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        long desiredBundleSizeOffsetUnits = Math.max(Math.max(1L, desiredBundleSizeBytes / this.getBytesPerOffset()), this.minBundleSize);
        ArrayList<OffsetBasedSource<T>> subSources = new ArrayList<OffsetBasedSource<T>>();
        long start = this.startOffset;
        long maxEnd = Math.min(this.endOffset, this.getMaxEndOffset(options));
        while (start < maxEnd) {
            long end = start + desiredBundleSizeOffsetUnits;
            long remaining = maxEnd - (end = Math.min(end, maxEnd));
            if (remaining < desiredBundleSizeOffsetUnits / 4L || remaining < this.minBundleSize) {
                end = maxEnd;
            }
            subSources.add(this.createSourceForSubrange(start, end));
            start = end;
        }
        return subSources;
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.startOffset >= 0L, "Start offset has value %s, must be non-negative", this.startOffset);
        Preconditions.checkArgument(this.endOffset >= 0L, "End offset has value %s, must be non-negative", this.endOffset);
        Preconditions.checkArgument(this.startOffset < this.endOffset, "Start offset %s must be before end offset %s", this.startOffset, this.endOffset);
        Preconditions.checkArgument(this.minBundleSize >= 0L, "minBundleSize has value %s, must be non-negative", this.minBundleSize);
    }

    public String toString() {
        long l = this.startOffset;
        long l2 = this.endOffset;
        return new StringBuilder(44).append("[").append(l).append(", ").append(l2).append(")").toString();
    }

    public long getBytesPerOffset() {
        return 1L;
    }

    public abstract long getMaxEndOffset(PipelineOptions var1) throws Exception;

    public abstract OffsetBasedSource<T> createSourceForSubrange(long var1, long var3);

    public static abstract class OffsetBasedReader<T>
    extends BoundedSource.BoundedReader<T> {
        private static final Logger LOG = LoggerFactory.getLogger(OffsetBasedReader.class);
        private OffsetBasedSource<T> source;
        private final OffsetRangeTracker rangeTracker;

        public OffsetBasedReader(OffsetBasedSource<T> source) {
            this.source = source;
            this.rangeTracker = new OffsetRangeTracker(source.getStartOffset(), source.getEndOffset());
        }

        protected abstract long getCurrentOffset() throws NoSuchElementException;

        protected boolean isAtSplitPoint() throws NoSuchElementException {
            return true;
        }

        @Override
        public final boolean start() throws IOException {
            return this.startImpl() && this.rangeTracker.tryReturnRecordAt(this.isAtSplitPoint(), this.getCurrentOffset());
        }

        @Override
        public final boolean advance() throws IOException {
            return this.advanceImpl() && this.rangeTracker.tryReturnRecordAt(this.isAtSplitPoint(), this.getCurrentOffset());
        }

        protected abstract boolean startImpl() throws IOException;

        protected abstract boolean advanceImpl() throws IOException;

        @Override
        public OffsetBasedSource<T> getCurrentSource() {
            return this.source;
        }

        @Override
        public Double getFractionConsumed() {
            return this.rangeTracker.getFractionConsumed();
        }

        @Override
        public final OffsetBasedSource<T> splitAtFraction(double fraction) {
            if (this.rangeTracker.getStopPosition() == Long.MAX_VALUE) {
                LOG.debug("Refusing to split unbounded OffsetBasedReader {} at fraction {}", (Object)this.rangeTracker, (Object)fraction);
                return null;
            }
            long splitOffset = this.rangeTracker.getPositionForFractionConsumed(fraction);
            LOG.debug("Proposing to split OffsetBasedReader {} at fraction {} (offset {})", new Object[]{this.rangeTracker, fraction, splitOffset});
            if (!this.rangeTracker.trySplitAtPosition(splitOffset)) {
                return null;
            }
            long start = this.source.getStartOffset();
            long end = this.source.getEndOffset();
            OffsetBasedSource<T> primary = this.source.createSourceForSubrange(start, splitOffset);
            OffsetBasedSource<T> residual = this.source.createSourceForSubrange(splitOffset, end);
            this.source = primary;
            return residual;
        }
    }
}

