/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.AcknowledgeRequest;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PubsubMessage;
import com.google.api.services.pubsub.model.PullRequest;
import com.google.api.services.pubsub.model.PullResponse;
import com.google.api.services.pubsub.model.ReceivedMessage;
import com.google.api.services.pubsub.model.Subscription;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.StringUtf8Coder;
import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.transforms.Create;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.Transport;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PDone;
import com.google.cloud.dataflow.sdk.values.PInput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubsubIO {
    private static final Logger LOG = LoggerFactory.getLogger(PubsubIO.class);
    public static final Coder<String> DEFAULT_PUBSUB_CODER = StringUtf8Coder.of();
    private static final Pattern PROJECT_ID_REGEXP = Pattern.compile("[a-z][-a-z0-9:.]{4,61}[a-z0-9]");
    private static final Pattern SUBSCRIPTION_REGEXP = Pattern.compile("projects/([^/]+)/subscriptions/(.+)");
    private static final Pattern TOPIC_REGEXP = Pattern.compile("projects/([^/]+)/topics/(.+)");
    private static final Pattern V1BETA1_SUBSCRIPTION_REGEXP = Pattern.compile("/subscriptions/([^/]+)/(.+)");
    private static final Pattern V1BETA1_TOPIC_REGEXP = Pattern.compile("/topics/([^/]+)/(.+)");
    private static final Pattern PUBSUB_NAME_REGEXP = Pattern.compile("[a-zA-Z][-._~%+a-zA-Z0-9]+");
    private static final int PUBSUB_NAME_MAX_LENGTH = 255;
    private static final String SUBSCRIPTION_RANDOM_TEST_PREFIX = "_random/";
    private static final String SUBSCRIPTION_STARTING_SIGNAL = "_starting_signal/";
    private static final String TOPIC_DEV_NULL_TEST_NAME = "/topics/dev/null";

    private static void validateProjectName(String project) {
        Matcher match = PROJECT_ID_REGEXP.matcher(project);
        if (!match.matches()) {
            String string = String.valueOf(project);
            throw new IllegalArgumentException(string.length() != 0 ? "Illegal project name specified in Pubsub subscription: ".concat(string) : new String("Illegal project name specified in Pubsub subscription: "));
        }
    }

    private static void validatePubsubName(String name) {
        if (name.length() > 255) {
            String string = String.valueOf(name);
            throw new IllegalArgumentException(string.length() != 0 ? "Pubsub object name is longer than 255 characters: ".concat(string) : new String("Pubsub object name is longer than 255 characters: "));
        }
        if (name.startsWith("goog")) {
            String string = String.valueOf(name);
            throw new IllegalArgumentException(string.length() != 0 ? "Pubsub object name cannot start with goog: ".concat(string) : new String("Pubsub object name cannot start with goog: "));
        }
        Matcher match = PUBSUB_NAME_REGEXP.matcher(name);
        if (!match.matches()) {
            throw new IllegalArgumentException(new StringBuilder(75 + String.valueOf(name).length()).append("Illegal Pubsub object name specified: ").append(name).append(" Please see Javadoc for naming rules.").toString());
        }
    }

    public static class Write {
        public static Bound<String> named(String name) {
            return new Bound<String>(DEFAULT_PUBSUB_CODER).named(name);
        }

        public static Bound<String> topic(String topic) {
            return new Bound<String>(DEFAULT_PUBSUB_CODER).topic(topic);
        }

        public static Bound<String> timestampLabel(String timestampLabel) {
            return new Bound<String>(DEFAULT_PUBSUB_CODER).timestampLabel(timestampLabel);
        }

        public static Bound<String> idLabel(String idLabel) {
            return new Bound<String>(DEFAULT_PUBSUB_CODER).idLabel(idLabel);
        }

        public static <T> Bound<T> withCoder(Coder<T> coder) {
            return new Bound<T>(coder);
        }

        public static class Bound<T>
        extends PTransform<PCollection<T>, PDone> {
            PubsubTopic topic;
            String timestampLabel;
            String idLabel;
            final Coder<T> coder;

            Bound(Coder<T> coder) {
                this.coder = coder;
            }

            Bound(String name, PubsubTopic topic, String timestampLabel, String idLabel, Coder<T> coder) {
                super(name);
                if (topic != null) {
                    this.topic = topic;
                }
                this.timestampLabel = timestampLabel;
                this.idLabel = idLabel;
                this.coder = coder;
            }

            public Bound<T> named(String name) {
                return new Bound<T>(name, this.topic, this.timestampLabel, this.idLabel, this.coder);
            }

            public Bound<T> topic(String topic) {
                return new Bound<T>(this.name, PubsubTopic.fromPath(topic), this.timestampLabel, this.idLabel, this.coder);
            }

            public Bound<T> timestampLabel(String timestampLabel) {
                return new Bound<T>(this.name, this.topic, timestampLabel, this.idLabel, this.coder);
            }

            public Bound<T> idLabel(String idLabel) {
                return new Bound<T>(this.name, this.topic, this.timestampLabel, idLabel, this.coder);
            }

            public <X> Bound<X> withCoder(Coder<X> coder) {
                return new Bound<X>(this.name, this.topic, this.timestampLabel, this.idLabel, coder);
            }

            @Override
            public PDone apply(PCollection<T> input) {
                if (this.topic == null) {
                    throw new IllegalStateException("need to set the topic of a PubsubIO.Write transform");
                }
                input.apply(ParDo.of(new PubsubWriter()));
                return PDone.in(input.getPipeline());
            }

            @Override
            protected Coder<Void> getDefaultOutputCoder() {
                return VoidCoder.of();
            }

            public PubsubTopic getTopic() {
                return this.topic;
            }

            public String getTimestampLabel() {
                return this.timestampLabel;
            }

            public String getIdLabel() {
                return this.idLabel;
            }

            public Coder<T> getCoder() {
                return this.coder;
            }

            private class PubsubWriter
            extends DoFn<T, Void> {
                private static final int MAX_PUBLISH_BATCH_SIZE = 100;
                private transient List<PubsubMessage> output;
                private transient Pubsub pubsubClient;

                private PubsubWriter() {
                }

                @Override
                public void startBundle(DoFn.Context c) {
                    this.output = new ArrayList<PubsubMessage>();
                    this.pubsubClient = Transport.newPubsubClient(c.getPipelineOptions().as(DataflowPipelineOptions.class)).build();
                }

                @Override
                public void processElement(DoFn.ProcessContext c) throws IOException {
                    PubsubMessage message = new PubsubMessage().encodeData(CoderUtils.encodeToByteArray(Bound.this.getCoder(), c.element()));
                    if (Bound.this.getTimestampLabel() != null) {
                        HashMap<String, String> attributes = message.getAttributes();
                        if (attributes == null) {
                            attributes = new HashMap<String, String>();
                            message.setAttributes(attributes);
                        }
                        attributes.put(Bound.this.getTimestampLabel(), String.valueOf(c.timestamp().getMillis()));
                    }
                    this.output.add(message);
                    if (this.output.size() >= 100) {
                        this.publish();
                    }
                }

                @Override
                public void finishBundle(DoFn.Context c) throws IOException {
                    if (!this.output.isEmpty()) {
                        this.publish();
                    }
                }

                private void publish() throws IOException {
                    PublishRequest publishRequest = new PublishRequest().setMessages(this.output);
                    this.pubsubClient.projects().topics().publish(Bound.this.getTopic().asV1Beta2Path(), publishRequest).execute();
                    this.output.clear();
                }
            }
        }
    }

    public static class Read {
        public static Bound<String> named(String name) {
            return new Bound<String>(DEFAULT_PUBSUB_CODER).named(name);
        }

        public static Bound<String> topic(String topic) {
            return new Bound<String>(DEFAULT_PUBSUB_CODER).topic(topic);
        }

        public static Bound<String> subscription(String subscription) {
            return new Bound<String>(DEFAULT_PUBSUB_CODER).subscription(subscription);
        }

        public static Bound<String> timestampLabel(String timestampLabel) {
            return new Bound<String>(DEFAULT_PUBSUB_CODER).timestampLabel(timestampLabel);
        }

        public static Bound<String> idLabel(String idLabel) {
            return new Bound<String>(DEFAULT_PUBSUB_CODER).idLabel(idLabel);
        }

        public static <T> Bound<T> withCoder(Coder<T> coder) {
            return new Bound<T>(coder);
        }

        public static Bound<String> maxNumRecords(int maxNumRecords) {
            return new Bound<String>(DEFAULT_PUBSUB_CODER).maxNumRecords(maxNumRecords);
        }

        public static Bound<String> maxReadTime(Duration maxReadTime) {
            return new Bound<String>(DEFAULT_PUBSUB_CODER).maxReadTime(maxReadTime);
        }

        public static class Bound<T>
        extends PTransform<PInput, PCollection<T>> {
            PubsubTopic topic;
            PubsubSubscription subscription;
            String timestampLabel;
            String idLabel;
            @Nullable
            final Coder<T> coder;
            int maxNumRecords;
            Duration maxReadTime;

            Bound(Coder<T> coder) {
                this.coder = coder;
            }

            Bound(String name, PubsubSubscription subscription, PubsubTopic topic, String timestampLabel, Coder<T> coder, String idLabel, int maxNumRecords, Duration maxReadTime) {
                super(name);
                if (subscription != null) {
                    this.subscription = subscription;
                }
                if (topic != null) {
                    this.topic = topic;
                }
                this.timestampLabel = timestampLabel;
                this.coder = coder;
                this.idLabel = idLabel;
                this.maxNumRecords = maxNumRecords;
                this.maxReadTime = maxReadTime;
            }

            public Bound<T> named(String name) {
                return new Bound<T>(name, this.subscription, this.topic, this.timestampLabel, this.coder, this.idLabel, this.maxNumRecords, this.maxReadTime);
            }

            public Bound<T> subscription(String subscription) {
                return new Bound<T>(this.name, PubsubSubscription.fromPath(subscription), this.topic, this.timestampLabel, this.coder, this.idLabel, this.maxNumRecords, this.maxReadTime);
            }

            public Bound<T> topic(String topic) {
                return new Bound<T>(this.name, this.subscription, PubsubTopic.fromPath(topic), this.timestampLabel, this.coder, this.idLabel, this.maxNumRecords, this.maxReadTime);
            }

            public Bound<T> timestampLabel(String timestampLabel) {
                return new Bound<T>(this.name, this.subscription, this.topic, timestampLabel, this.coder, this.idLabel, this.maxNumRecords, this.maxReadTime);
            }

            public Bound<T> idLabel(String idLabel) {
                return new Bound<T>(this.name, this.subscription, this.topic, this.timestampLabel, this.coder, idLabel, this.maxNumRecords, this.maxReadTime);
            }

            public <X> Bound<X> withCoder(Coder<X> coder) {
                return new Bound<X>(this.name, this.subscription, this.topic, this.timestampLabel, coder, this.idLabel, this.maxNumRecords, this.maxReadTime);
            }

            public Bound<T> maxNumRecords(int maxNumRecords) {
                return new Bound<T>(this.name, this.subscription, this.topic, this.timestampLabel, this.coder, this.idLabel, maxNumRecords, this.maxReadTime);
            }

            public Bound<T> maxReadTime(Duration maxReadTime) {
                return new Bound<T>(this.name, this.subscription, this.topic, this.timestampLabel, this.coder, this.idLabel, this.maxNumRecords, maxReadTime);
            }

            @Override
            public PCollection<T> apply(PInput input) {
                boolean boundedOutput;
                if (this.topic == null && this.subscription == null) {
                    throw new IllegalStateException("need to set either the topic or the subscription for a PubsubIO.Read transform");
                }
                if (this.topic != null && this.subscription != null) {
                    throw new IllegalStateException("Can't set both the topic and the subscription for a PubsubIO.Read transform");
                }
                boolean bl = boundedOutput = this.getMaxNumRecords() > 0 || this.getMaxReadTime() != null;
                if (boundedOutput) {
                    return ((PCollection)((PCollection)((PCollection)input.getPipeline().begin().apply(Create.of(new Void[]{null}))).setCoder((Coder)VoidCoder.of())).apply(ParDo.of(new PubsubReader()))).setCoder((Coder)this.coder);
                }
                return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.UNBOUNDED).setCoder((Coder)this.coder);
            }

            @Override
            protected Coder<T> getDefaultOutputCoder() {
                return this.coder;
            }

            public PubsubTopic getTopic() {
                return this.topic;
            }

            public PubsubSubscription getSubscription() {
                return this.subscription;
            }

            public String getTimestampLabel() {
                return this.timestampLabel;
            }

            public Coder<T> getCoder() {
                return this.coder;
            }

            public String getIdLabel() {
                return this.idLabel;
            }

            public int getMaxNumRecords() {
                return this.maxNumRecords;
            }

            public Duration getMaxReadTime() {
                return this.maxReadTime;
            }

            private class PubsubReader
            extends DoFn<Void, T> {
                private static final int DEFAULT_PULL_SIZE = 100;

                private PubsubReader() {
                }

                @Override
                public void processElement(DoFn.ProcessContext c) throws IOException {
                    String subscription;
                    Pubsub pubsubClient = Transport.newPubsubClient(c.getPipelineOptions().as(DataflowPipelineOptions.class)).build();
                    if (Bound.this.getSubscription() == null) {
                        String topic = Bound.this.getTopic().asV1Beta2Path();
                        String[] split = topic.split("/");
                        String string = split[1];
                        String string2 = split[3];
                        long l = new Random().nextLong();
                        subscription = new StringBuilder(54 + String.valueOf(string).length() + String.valueOf(string2).length()).append("projects/").append(string).append("/subscriptions/").append(string2).append("_dataflow_").append(l).toString();
                        Subscription subInfo = new Subscription().setAckDeadlineSeconds(Integer.valueOf(60)).setTopic(topic);
                        try {
                            pubsubClient.projects().subscriptions().create(subscription, subInfo).execute();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to create subscription: ", e);
                        }
                    } else {
                        subscription = Bound.this.getSubscription().asV1Beta2Path();
                    }
                    Instant endTime = Bound.this.getMaxReadTime() == null ? new Instant(Long.MAX_VALUE) : Instant.now().plus((ReadableDuration)Bound.this.getMaxReadTime());
                    ArrayList<PubsubMessage> messages = new ArrayList<PubsubMessage>();
                    try {
                        while ((Bound.this.getMaxNumRecords() == 0 || messages.size() < Bound.this.getMaxNumRecords()) && Instant.now().isBefore((ReadableInstant)endTime)) {
                            PullRequest pullRequest = new PullRequest().setReturnImmediately(Boolean.valueOf(false));
                            if (Bound.this.getMaxNumRecords() > 0) {
                                pullRequest.setMaxMessages(Integer.valueOf(Bound.this.getMaxNumRecords() - messages.size()));
                            } else {
                                pullRequest.setMaxMessages(Integer.valueOf(100));
                            }
                            PullResponse pullResponse = (PullResponse)pubsubClient.projects().subscriptions().pull(subscription, pullRequest).execute();
                            ArrayList<String> ackIds = new ArrayList<String>();
                            if (pullResponse.getReceivedMessages() != null) {
                                for (ReceivedMessage received : pullResponse.getReceivedMessages()) {
                                    messages.add(received.getMessage());
                                    ackIds.add(received.getAckId());
                                }
                            }
                            if (ackIds.size() == 0) continue;
                            AcknowledgeRequest ackRequest = new AcknowledgeRequest().setAckIds(ackIds);
                            pubsubClient.projects().subscriptions().acknowledge(subscription, ackRequest).execute();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unexpected exception while reading from Pubsub: ", e);
                    }
                    finally {
                        if (Bound.this.getTopic() != null) {
                            try {
                                pubsubClient.projects().subscriptions().delete(subscription).execute();
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Failed to delete subscription: ", e);
                            }
                        }
                    }
                    for (PubsubMessage message : messages) {
                        Instant timestamp;
                        if (Bound.this.getTimestampLabel() == null) {
                            timestamp = Instant.now();
                        } else {
                            if (message.getAttributes() == null || !message.getAttributes().containsKey(Bound.this.getTimestampLabel())) {
                                String string = String.valueOf(Bound.this.getTimestampLabel());
                                throw new RuntimeException(string.length() != 0 ? "Message from pubsub missing timestamp label: ".concat(string) : new String("Message from pubsub missing timestamp label: "));
                            }
                            timestamp = new Instant(Long.parseLong((String)message.getAttributes().get(Bound.this.getTimestampLabel())));
                        }
                        c.outputWithTimestamp(CoderUtils.decodeFromByteArray(Bound.this.getCoder(), message.decodeData()), timestamp);
                    }
                }
            }
        }
    }

    public static class PubsubTopic
    implements Serializable {
        private final Type type;
        private final String project;
        private final String topic;

        public PubsubTopic(Type type, String project, String topic) {
            this.type = type;
            this.project = project;
            this.topic = topic;
        }

        public static PubsubTopic fromPath(String path) {
            String topicName;
            String projectName;
            if (path.equals(PubsubIO.TOPIC_DEV_NULL_TEST_NAME)) {
                return new PubsubTopic(Type.FAKE, "", path);
            }
            Matcher v1beta1Match = V1BETA1_TOPIC_REGEXP.matcher(path);
            if (v1beta1Match.matches()) {
                LOG.warn("Saw topic in v1beta1 format.  Topics should be in the format projects/<project_id>/topics/<topic_name>");
                projectName = v1beta1Match.group(1);
                topicName = v1beta1Match.group(2);
            } else {
                Matcher match = TOPIC_REGEXP.matcher(path);
                if (!match.matches()) {
                    String string = String.valueOf(path);
                    throw new IllegalArgumentException(string.length() != 0 ? "Pubsub topic is not in projects/<project_id>/topics/<topic_name> format: ".concat(string) : new String("Pubsub topic is not in projects/<project_id>/topics/<topic_name> format: "));
                }
                projectName = match.group(1);
                topicName = match.group(2);
            }
            PubsubIO.validateProjectName(projectName);
            PubsubIO.validatePubsubName(topicName);
            return new PubsubTopic(Type.NORMAL, projectName, topicName);
        }

        public String asV1Beta1Path() {
            if (this.type == Type.NORMAL) {
                String string = this.project;
                String string2 = this.topic;
                return new StringBuilder(9 + String.valueOf(string).length() + String.valueOf(string2).length()).append("/topics/").append(string).append("/").append(string2).toString();
            }
            return this.topic;
        }

        public String asV1Beta2Path() {
            if (this.type == Type.NORMAL) {
                String string = this.project;
                String string2 = this.topic;
                return new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append("projects/").append(string).append("/topics/").append(string2).toString();
            }
            return this.topic;
        }

        private static enum Type {
            NORMAL,
            FAKE;

        }
    }

    public static class PubsubSubscription
    implements Serializable {
        private final Type type;
        private final String project;
        private final String subscription;

        private PubsubSubscription(Type type, String project, String subscription) {
            this.type = type;
            this.project = project;
            this.subscription = subscription;
        }

        public static PubsubSubscription fromPath(String path) {
            String subscriptionName;
            String projectName;
            if (path.startsWith(PubsubIO.SUBSCRIPTION_RANDOM_TEST_PREFIX) || path.startsWith(PubsubIO.SUBSCRIPTION_STARTING_SIGNAL)) {
                return new PubsubSubscription(Type.FAKE, "", path);
            }
            Matcher v1beta1Match = V1BETA1_SUBSCRIPTION_REGEXP.matcher(path);
            if (v1beta1Match.matches()) {
                LOG.warn("Saw subscription in v1beta1 format. Subscriptions should be in the format projects/<project_id>/subscriptions/<subscription_name>");
                projectName = v1beta1Match.group(1);
                subscriptionName = v1beta1Match.group(2);
            } else {
                Matcher match = SUBSCRIPTION_REGEXP.matcher(path);
                if (!match.matches()) {
                    String string = String.valueOf("Pubsub subscription is not in projects/<project_id>/subscriptions/<subscription_name> format: ");
                    String string2 = String.valueOf(path);
                    throw new IllegalArgumentException(string2.length() != 0 ? string.concat(string2) : new String(string));
                }
                projectName = match.group(1);
                subscriptionName = match.group(2);
            }
            PubsubIO.validateProjectName(projectName);
            PubsubIO.validatePubsubName(subscriptionName);
            return new PubsubSubscription(Type.NORMAL, projectName, subscriptionName);
        }

        public String asV1Beta1Path() {
            if (this.type == Type.NORMAL) {
                String string = this.project;
                String string2 = this.subscription;
                return new StringBuilder(16 + String.valueOf(string).length() + String.valueOf(string2).length()).append("/subscriptions/").append(string).append("/").append(string2).toString();
            }
            return this.subscription;
        }

        public String asV1Beta2Path() {
            if (this.type == Type.NORMAL) {
                String string = this.project;
                String string2 = this.subscription;
                return new StringBuilder(24 + String.valueOf(string).length() + String.valueOf(string2).length()).append("projects/").append(string).append("/subscriptions/").append(string2).toString();
            }
            return this.subscription;
        }

        private static enum Type {
            NORMAL,
            FAKE;

        }
    }
}

