/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.StringUtf8Coder;
import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.primitives.Ints;
import com.google.cloud.dataflow.sdk.runners.DirectPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.worker.FileBasedReader;
import com.google.cloud.dataflow.sdk.runners.worker.TextReader;
import com.google.cloud.dataflow.sdk.runners.worker.TextSink;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.ReaderUtils;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.common.worker.Sink;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PDone;
import com.google.cloud.dataflow.sdk.values.PInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class TextIO {
    public static final Coder<String> DEFAULT_TEXT_CODER = StringUtf8Coder.of();
    private static final Pattern SHARD_OUTPUT_PATTERN = Pattern.compile("@([0-9]+|\\*)");

    private static void validateOutputComponent(String partialFilePattern) {
        String string = String.valueOf(partialFilePattern);
        Preconditions.checkArgument(!SHARD_OUTPUT_PATTERN.matcher(partialFilePattern).find(), string.length() != 0 ? "Output name components are not allowed to contain @* or @N patterns: ".concat(string) : new String("Output name components are not allowed to contain @* or @N patterns: "));
    }

    private static <T> void evaluateReadHelper(Read.Bound<T> transform, DirectPipelineRunner.EvaluationContext context) {
        TextReader reader = new TextReader(transform.filepattern, true, null, null, transform.coder, transform.getCompressionType());
        List elems = ReaderUtils.readElemsFromReader(reader);
        context.setPCollection((PCollection)context.getOutput(transform), elems);
    }

    private static <T> void evaluateWriteHelper(Write.Bound<T> transform, DirectPipelineRunner.EvaluationContext context) {
        List elems = context.getPCollection((PCollection)context.getInput(transform));
        int numShards = transform.numShards;
        if (numShards < 1) {
            numShards = 1;
        }
        TextSink writer = TextSink.createForDirectPipelineRunner(transform.filenamePrefix, transform.getShardNameTemplate(), transform.filenameSuffix, numShards, true, null, null, transform.coder);
        try (Sink.SinkWriter sink = writer.writer();){
            for (Object elem : elems) {
                sink.add(WindowedValue.valueInGlobalWindow(elem));
            }
        }
        catch (IOException exn) {
            String string = transform.filenamePrefix;
            throw new RuntimeException(new StringBuilder(33 + String.valueOf(string).length()).append("unable to write to output file \"").append(string).append("\"").toString(), exn);
        }
    }

    public static enum CompressionType implements FileBasedReader.DecompressingStreamFactory
    {
        AUTO(""),
        UNCOMPRESSED(""),
        GZIP(".gz"){

            @Override
            public InputStream createInputStream(InputStream inputStream) throws IOException {
                PushbackInputStream stream = new PushbackInputStream(inputStream, 2);
                byte[] headerBytes = new byte[2];
                int bytesRead = stream.read(headerBytes);
                stream.unread(headerBytes, 0, bytesRead);
                int header = Ints.fromBytes((byte)0, (byte)0, headerBytes[1], headerBytes[0]);
                if (header == 35615) {
                    return new GZIPInputStream(stream);
                }
                return stream;
            }
        }
        ,
        BZIP2(".bz2"){

            @Override
            public InputStream createInputStream(InputStream inputStream) throws IOException {
                return new BZip2CompressorInputStream(inputStream);
            }
        };

        private String filenameSuffix;

        private CompressionType(String suffix) {
            this.filenameSuffix = suffix;
        }

        public boolean matches(String filename) {
            return filename.toLowerCase().endsWith(this.filenameSuffix.toLowerCase());
        }

        @Override
        public InputStream createInputStream(InputStream inputStream) throws IOException {
            return inputStream;
        }
    }

    public static class Write {
        public static Bound<String> named(String name) {
            return new Bound<String>(DEFAULT_TEXT_CODER).named(name);
        }

        public static Bound<String> to(String prefix) {
            return new Bound<String>(DEFAULT_TEXT_CODER).to(prefix);
        }

        public static Bound<String> withSuffix(String nameExtension) {
            return new Bound<String>(DEFAULT_TEXT_CODER).withSuffix(nameExtension);
        }

        public static Bound<String> withNumShards(int numShards) {
            return new Bound<String>(DEFAULT_TEXT_CODER).withNumShards(numShards);
        }

        public static Bound<String> withShardNameTemplate(String shardTemplate) {
            return new Bound<String>(DEFAULT_TEXT_CODER).withShardNameTemplate(shardTemplate);
        }

        public static Bound<String> withoutSharding() {
            return new Bound<String>(DEFAULT_TEXT_CODER).withoutSharding();
        }

        public static <T> Bound<T> withCoder(Coder<T> coder) {
            return new Bound<T>(coder);
        }

        public static Bound<String> withoutValidation() {
            return new Bound<String>(DEFAULT_TEXT_CODER).withoutValidation();
        }

        public static class Bound<T>
        extends PTransform<PCollection<T>, PDone> {
            @Nullable
            final String filenamePrefix;
            final String filenameSuffix;
            final Coder<T> coder;
            final int numShards;
            final String shardTemplate;
            final boolean validate;

            Bound(Coder<T> coder) {
                this(null, null, "", coder, 0, "-SSSSS-of-NNNNN", true);
            }

            Bound(String name, String filenamePrefix, String filenameSuffix, Coder<T> coder, int numShards, String shardTemplate, boolean validate) {
                super(name);
                this.coder = coder;
                this.filenamePrefix = filenamePrefix;
                this.filenameSuffix = filenameSuffix;
                this.numShards = numShards;
                this.shardTemplate = shardTemplate;
                this.validate = validate;
            }

            public Bound<T> named(String name) {
                return new Bound<T>(name, this.filenamePrefix, this.filenameSuffix, this.coder, this.numShards, this.shardTemplate, this.validate);
            }

            public Bound<T> to(String filenamePrefix) {
                TextIO.validateOutputComponent(filenamePrefix);
                return new Bound<T>(this.name, filenamePrefix, this.filenameSuffix, this.coder, this.numShards, this.shardTemplate, this.validate);
            }

            public Bound<T> withSuffix(String nameExtension) {
                TextIO.validateOutputComponent(nameExtension);
                return new Bound<T>(this.name, this.filenamePrefix, nameExtension, this.coder, this.numShards, this.shardTemplate, this.validate);
            }

            public Bound<T> withNumShards(int numShards) {
                Preconditions.checkArgument(numShards >= 0);
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.coder, numShards, this.shardTemplate, this.validate);
            }

            public Bound<T> withShardNameTemplate(String shardTemplate) {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.coder, this.numShards, shardTemplate, this.validate);
            }

            public Bound<T> withoutSharding() {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.coder, 1, "", this.validate);
            }

            public <X> Bound<X> withCoder(Coder<X> coder) {
                return new Bound<X>(this.name, this.filenamePrefix, this.filenameSuffix, coder, this.numShards, this.shardTemplate, this.validate);
            }

            public Bound<T> withoutValidation() {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.coder, this.numShards, this.shardTemplate, false);
            }

            @Override
            public PDone apply(PCollection<T> input) {
                if (this.filenamePrefix == null) {
                    throw new IllegalStateException("need to set the filename prefix of a TextIO.Write transform");
                }
                return PDone.in(input.getPipeline());
            }

            public String getShardNameTemplate() {
                return this.shardTemplate;
            }

            @Override
            protected Coder<Void> getDefaultOutputCoder() {
                return VoidCoder.of();
            }

            public String getFilenamePrefix() {
                return this.filenamePrefix;
            }

            public String getShardTemplate() {
                return this.shardTemplate;
            }

            public int getNumShards() {
                return this.numShards;
            }

            public String getFilenameSuffix() {
                return this.filenameSuffix;
            }

            public Coder<T> getCoder() {
                return this.coder;
            }

            public boolean needsValidation() {
                return this.validate;
            }

            static {
                DirectPipelineRunner.registerDefaultTransformEvaluator(Bound.class, new DirectPipelineRunner.TransformEvaluator<Bound>(){

                    @Override
                    public void evaluate(Bound transform, DirectPipelineRunner.EvaluationContext context) {
                        TextIO.evaluateWriteHelper(transform, context);
                    }
                });
            }
        }
    }

    public static class Read {
        public static Bound<String> named(String name) {
            return new Bound<String>(DEFAULT_TEXT_CODER).named(name);
        }

        public static Bound<String> from(String filepattern) {
            return new Bound<String>(DEFAULT_TEXT_CODER).from(filepattern);
        }

        public static <T> Bound<T> withCoder(Coder<T> coder) {
            return new Bound<T>(coder);
        }

        public static Bound<String> withoutValidation() {
            return new Bound<String>(DEFAULT_TEXT_CODER).withoutValidation();
        }

        public static Bound<String> withCompressionType(CompressionType compressionType) {
            return new Bound<String>(DEFAULT_TEXT_CODER).withCompressionType(compressionType);
        }

        public static class Bound<T>
        extends PTransform<PInput, PCollection<T>> {
            @Nullable
            final String filepattern;
            @Nullable
            final Coder<T> coder;
            final boolean validate;
            final CompressionType compressionType;

            Bound(Coder<T> coder) {
                this(null, null, coder, true, CompressionType.AUTO);
            }

            Bound(String name, String filepattern, Coder<T> coder, boolean validate, CompressionType compressionType) {
                super(name);
                this.coder = coder;
                this.filepattern = filepattern;
                this.validate = validate;
                this.compressionType = compressionType;
            }

            public Bound<T> named(String name) {
                return new Bound<T>(name, this.filepattern, this.coder, this.validate, this.compressionType);
            }

            public Bound<T> from(String filepattern) {
                return new Bound<T>(this.name, filepattern, this.coder, this.validate, this.compressionType);
            }

            public <X> Bound<X> withCoder(Coder<X> coder) {
                return new Bound<X>(this.name, this.filepattern, coder, this.validate, this.compressionType);
            }

            public Bound<T> withoutValidation() {
                return new Bound<T>(this.name, this.filepattern, this.coder, false, this.compressionType);
            }

            public Bound<T> withCompressionType(CompressionType compressionType) {
                return new Bound<T>(this.name, this.filepattern, this.coder, this.validate, compressionType);
            }

            @Override
            public PCollection<T> apply(PInput input) {
                if (this.filepattern == null) {
                    throw new IllegalStateException("need to set the filepattern of a TextIO.Read transform");
                }
                return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.BOUNDED).setCoder((Coder)this.coder);
            }

            @Override
            protected Coder<T> getDefaultOutputCoder() {
                return this.coder;
            }

            public String getFilepattern() {
                return this.filepattern;
            }

            public boolean needsValidation() {
                return this.validate;
            }

            public CompressionType getCompressionType() {
                return this.compressionType;
            }

            static {
                DirectPipelineRunner.registerDefaultTransformEvaluator(Bound.class, new DirectPipelineRunner.TransformEvaluator<Bound>(){

                    @Override
                    public void evaluate(Bound transform, DirectPipelineRunner.EvaluationContext context) {
                        TextIO.evaluateReadHelper(transform, context);
                    }
                });
            }
        }
    }
}

