/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.JAXBCoder;
import com.google.cloud.dataflow.sdk.io.FileBasedSource;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLInputFactory2;

public class XmlSource<T>
extends FileBasedSource<T> {
    private static final String XML_VERSION = "1.1";
    private static final int DEFAULT_MIN_BUNDLE_SIZE = 8192;
    private final String rootElement;
    private final String recordElement;
    private final Class<T> recordClass;

    public static <T> XmlSource<T> from(String fileOrPatternSpec) {
        return new XmlSource<T>(fileOrPatternSpec, 8192L, null, null, null);
    }

    public XmlSource<T> withRootElement(String rootElement) {
        return new XmlSource<T>(this.getFileOrPatternSpec(), this.getMinBundleSize(), rootElement, this.recordElement, this.recordClass);
    }

    public XmlSource<T> withRecordElement(String recordElement) {
        return new XmlSource<T>(this.getFileOrPatternSpec(), this.getMinBundleSize(), this.rootElement, recordElement, this.recordClass);
    }

    public XmlSource<T> withRecordClass(Class<T> recordClass) {
        return new XmlSource<T>(this.getFileOrPatternSpec(), this.getMinBundleSize(), this.rootElement, this.recordElement, recordClass);
    }

    public XmlSource<T> withMinBundleSize(long minBundleSize) {
        return new XmlSource<T>(this.getFileOrPatternSpec(), minBundleSize, this.rootElement, this.recordElement, this.recordClass);
    }

    private XmlSource(String fileOrPattern, long minBundleSize, String rootElement, String recordElement, Class<T> recordClass) {
        super(fileOrPattern, minBundleSize);
        this.rootElement = rootElement;
        this.recordElement = recordElement;
        this.recordClass = recordClass;
    }

    private XmlSource(String fileOrPattern, long minBundleSize, long startOffset, long endOffset, String rootElement, String recordElement, Class<T> recordClass) {
        super(fileOrPattern, minBundleSize, startOffset, endOffset);
        this.rootElement = rootElement;
        this.recordElement = recordElement;
        this.recordClass = recordClass;
    }

    @Override
    public FileBasedSource<T> createForSubrangeOfFile(String fileName, long start, long end) {
        return new XmlSource<T>(fileName, this.getMinBundleSize(), start, end, this.rootElement, this.recordElement, this.recordClass);
    }

    @Override
    public FileBasedSource.FileBasedReader<T> createSingleFileReader(PipelineOptions options) {
        return new XMLReader(this);
    }

    @Override
    public boolean producesSortedKeys(PipelineOptions options) throws Exception {
        return false;
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkNotNull(this.rootElement, "rootElement is null. Use builder method withRootElement() to set this.");
        Preconditions.checkNotNull(this.recordElement, "recordElement is null. Use builder method withRecordElement() to set this.");
        Preconditions.checkNotNull(this.recordClass, "recordClass is null. Use builder method withRecordClass() to set this.");
    }

    @Override
    public Coder<T> getDefaultOutputCoder() {
        return JAXBCoder.of(this.recordClass);
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public String getRecordElement() {
        return this.recordElement;
    }

    public Class<T> getRecordClass() {
        return this.recordClass;
    }

    private static class XMLReader<T>
    extends FileBasedSource.FileBasedReader<T> {
        private static final int BUF_SIZE = 1024;
        private static final int MAX_CHAR_BYTES = 4;
        private long parserBaseOffset = 0L;
        private boolean readingStarted = false;
        private boolean emptyBundle = false;
        private Unmarshaller jaxbUnmarshaller = null;
        private XMLStreamReader parser = null;
        private T currentRecord = null;
        private long currentByteOffset = 0L;

        public XMLReader(XmlSource<T> source) {
            super(source);
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{((XmlSource)this.getCurrentSource()).recordClass});
                this.jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                this.jaxbUnmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        throw new RuntimeException(event.getMessage(), event.getLinkedException());
                    }
                });
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public XmlSource<T> getCurrentSource() {
            return (XmlSource)super.getCurrentSource();
        }

        @Override
        protected void startReading(ReadableByteChannel channel) throws IOException {
            ByteArrayOutputStream preambleByteBuffer = new ByteArrayOutputStream();
            String string = String.valueOf("<?xml version=\"1.1\" encoding=\"UTF-8\" ?><");
            String string2 = ((XmlSource)this.getCurrentSource()).rootElement;
            byte[] dummyStartDocumentBytes = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append(">").toString().getBytes(StandardCharsets.UTF_8);
            preambleByteBuffer.write(dummyStartDocumentBytes);
            long offsetInFileOfRecordElement = this.getFirstOccurenceOfRecordElement(channel, preambleByteBuffer);
            if (offsetInFileOfRecordElement < 0L) {
                this.emptyBundle = true;
                return;
            }
            byte[] preambleBytes = preambleByteBuffer.toByteArray();
            this.currentByteOffset = offsetInFileOfRecordElement;
            this.setUpXMLParser(channel, preambleBytes);
            this.parserBaseOffset = offsetInFileOfRecordElement - (long)dummyStartDocumentBytes.length;
            this.readingStarted = true;
        }

        private long getFirstOccurenceOfRecordElement(ReadableByteChannel channel, ByteArrayOutputStream preambleByteBuffer) throws IOException {
            int byteIndexInRecordElementToMatch = 0;
            boolean recordStartBytesMatched = false;
            boolean fullyMatched = false;
            long offsetInFileOfCurrentByte = this.getCurrentSource().getStartOffset() - 1L;
            long startingOffsetInFileOfCurrentMatch = -1L;
            boolean matchStarted = false;
            byte[] charBytes = new byte[4];
            int charBytesFound = 0;
            ByteBuffer buf = ByteBuffer.allocate(1024);
            String string = String.valueOf(((XmlSource)this.getCurrentSource()).recordElement);
            byte[] recordStartBytes = (string.length() != 0 ? "<".concat(string) : new String("<")).getBytes(StandardCharsets.UTF_8);
            block0: while (channel.read(buf) > 0) {
                buf.flip();
                while (buf.hasRemaining()) {
                    ++offsetInFileOfCurrentByte;
                    byte b = buf.get();
                    boolean reset = false;
                    if (recordStartBytesMatched) {
                        charBytes[charBytesFound] = b;
                        Character c = null;
                        if (++charBytesFound != charBytes.length) continue;
                        CharBuffer charBuf = CharBuffer.allocate(1);
                        ByteArrayInputStream charBufStream = new ByteArrayInputStream(charBytes);
                        InputStreamReader reader = new InputStreamReader((InputStream)charBufStream, StandardCharsets.UTF_8);
                        int read = ((Reader)reader).read();
                        if (read <= 0) {
                            return -1L;
                        }
                        charBuf.flip();
                        c = Character.valueOf((char)read);
                        if (Character.isWhitespace(c.charValue()) || c.charValue() == '>' || c.charValue() == '/') {
                            fullyMatched = true;
                            preambleByteBuffer.write(recordStartBytes);
                            preambleByteBuffer.write(charBytes);
                            while (buf.hasRemaining()) {
                                preambleByteBuffer.write(buf.get());
                            }
                            break block0;
                        }
                        ByteBuffer newbuf = ByteBuffer.allocate(1024);
                        newbuf.put(charBytes);
                        offsetInFileOfCurrentByte -= (long)charBytes.length;
                        while (buf.hasRemaining()) {
                            newbuf.put(buf.get());
                        }
                        newbuf.flip();
                        buf = newbuf;
                        reset = true;
                    } else if (b == recordStartBytes[byteIndexInRecordElementToMatch]) {
                        if (!matchStarted) {
                            matchStarted = true;
                            startingOffsetInFileOfCurrentMatch = offsetInFileOfCurrentByte;
                        }
                        ++byteIndexInRecordElementToMatch;
                    } else {
                        reset = true;
                    }
                    if (reset) {
                        byteIndexInRecordElementToMatch = 0;
                        startingOffsetInFileOfCurrentMatch = -1L;
                        matchStarted = false;
                        recordStartBytesMatched = false;
                        charBytes = new byte[4];
                        charBytesFound = 0;
                    }
                    if (byteIndexInRecordElementToMatch != recordStartBytes.length) continue;
                    recordStartBytesMatched = true;
                }
                buf.clear();
            }
            if (!fullyMatched) {
                return -1L;
            }
            return startingOffsetInFileOfCurrentMatch;
        }

        private void setUpXMLParser(ReadableByteChannel channel, byte[] lookAhead) throws IOException {
            try {
                String localName;
                int event;
                XMLInputFactory2 xmlInputFactory = (XMLInputFactory2)XMLInputFactory.newInstance();
                this.parser = xmlInputFactory.createXMLStreamReader((InputStream)new SequenceInputStream(new ByteArrayInputStream(lookAhead), Channels.newInputStream(channel)), "UTF-8");
                while ((event = this.parser.next()) != 1 || !(localName = this.parser.getLocalName()).equals(((XmlSource)this.getCurrentSource()).recordElement)) {
                }
            }
            catch (FactoryConfigurationError | XMLStreamException e) {
                throw new IOException(e);
            }
        }

        @Override
        protected boolean readNextRecord() throws IOException {
            if (this.emptyBundle) {
                this.currentByteOffset = Long.MAX_VALUE;
                return false;
            }
            try {
                this.currentByteOffset = this.parserBaseOffset + (long)this.parser.getLocation().getCharacterOffset();
                while (this.parser.getEventType() != 1) {
                    this.parser.next();
                    this.currentByteOffset = this.parserBaseOffset + (long)this.parser.getLocation().getCharacterOffset();
                    if (this.parser.getEventType() != 8) continue;
                    this.currentByteOffset = Long.MAX_VALUE;
                    return false;
                }
                JAXBElement jb = this.jaxbUnmarshaller.unmarshal(this.parser, ((XmlSource)this.getCurrentSource()).recordClass);
                this.currentRecord = jb.getValue();
                return true;
            }
            catch (JAXBException | XMLStreamException e) {
                throw new IOException(e);
            }
        }

        @Override
        public T getCurrent() throws NoSuchElementException {
            if (!this.readingStarted) {
                throw new NoSuchElementException();
            }
            return this.currentRecord;
        }

        @Override
        protected boolean isAtSplitPoint() {
            return true;
        }

        @Override
        protected long getCurrentOffset() {
            return this.currentByteOffset;
        }
    }
}

