/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.google.cloud.dataflow.sdk.options.ApplicationNameOptions;
import com.google.cloud.dataflow.sdk.options.BigQueryOptions;
import com.google.cloud.dataflow.sdk.options.CloudDebuggerOptions;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineDebugOptions;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineWorkerPoolOptions;
import com.google.cloud.dataflow.sdk.options.DataflowWorkerLoggingOptions;
import com.google.cloud.dataflow.sdk.options.Default;
import com.google.cloud.dataflow.sdk.options.DefaultValueFactory;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.GcpOptions;
import com.google.cloud.dataflow.sdk.options.GcsOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.StreamingOptions;
import com.google.cloud.dataflow.sdk.options.Validation;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Description(value="Options that configure the Dataflow pipeline.")
public interface DataflowPipelineOptions
extends PipelineOptions,
GcpOptions,
ApplicationNameOptions,
DataflowPipelineDebugOptions,
DataflowPipelineWorkerPoolOptions,
BigQueryOptions,
GcsOptions,
StreamingOptions,
CloudDebuggerOptions,
DataflowWorkerLoggingOptions {
    public static final String DATAFLOW_STORAGE_LOCATION = "Dataflow Storage Location";

    @Override
    @Description(value="Project id. Required when running a Dataflow in the cloud. See https://cloud.google.com/storage/docs/projects for further details.")
    @Validation.Required
    public String getProject();

    @Override
    public void setProject(String var1);

    @Description(value="GCS path for temporary files, eg \"gs://bucket/object\". Must be a valid Cloud Storage url, beginning with the prefix \"gs://\". At least one of tempLocation or stagingLocation must be set. If tempLocation is unset, defaults to using stagingLocation.")
    @Validation.Required(groups={"Dataflow Storage Location"})
    public String getTempLocation();

    public void setTempLocation(String var1);

    @Description(value="GCS path for staging local files, e.g. \"gs://bucket/object\". Must be a valid Cloud Storage url, beginning with the prefix \"gs://\". At least one of stagingLocation or tempLocation must be set. If stagingLocation is unset, defaults to using tempLocation.")
    @Validation.Required(groups={"Dataflow Storage Location"})
    public String getStagingLocation();

    public void setStagingLocation(String var1);

    @Description(value="The Dataflow job name is used as an idempotence key within the Dataflow service. If there is an existing job that is currently active, another active job with the same name will not be able to be created. Defaults to using the ApplicationName-UserName-Date.")
    @Default.InstanceFactory(value=JobNameFactory.class)
    public String getJobName();

    public void setJobName(String var1);

    public static class JobNameFactory
    implements DefaultValueFactory<String> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"MMddHHmmss").withZone(DateTimeZone.UTC);

        @Override
        public String create(PipelineOptions options) {
            String appName = options.as(ApplicationNameOptions.class).getAppName();
            String normalizedAppName = appName == null || appName.length() == 0 ? "dataflow" : appName.toLowerCase().replaceAll("[^a-z0-9]", "0").replaceAll("^[^a-z]", "a");
            String userName = MoreObjects.firstNonNull(System.getProperty("user.name"), "");
            String normalizedUserName = userName.toLowerCase().replaceAll("[^a-z0-9]", "0");
            String datePart = FORMATTER.print(DateTimeUtils.currentTimeMillis());
            return new StringBuilder(2 + String.valueOf(normalizedAppName).length() + String.valueOf(normalizedUserName).length() + String.valueOf(datePart).length()).append(normalizedAppName).append("-").append(normalizedUserName).append("-").append(datePart).toString();
        }
    }
}

