/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import java.util.List;

@Description(value="Options that are used to configure the Dataflow pipeline worker pool.")
public interface DataflowPipelineWorkerPoolOptions
extends PipelineOptions {
    @Description(value="Disk source image to use by VMs for jobs. See https://developers.google.com/compute/docs/images for further details.")
    public String getDiskSourceImage();

    public void setDiskSourceImage(String var1);

    @Description(value="Number of workers to use when executing the Dataflow job. Note that selection of an autoscaling algorithm other then \"NONE\" will affect the size of the worker pool. If left unspecified, the Dataflow service will determine the number of workers.")
    public int getNumWorkers();

    public void setNumWorkers(int var1);

    @Description(value="[Experimental] The autoscaling algorithm to use for the workerpool. NONE: does not change the size of the worker pool. BASIC: autoscale the worker pool size up to maxNumWorkers until the job completes.")
    @Experimental(value=Experimental.Kind.AUTOSCALING)
    public AutoscalingAlgorithmType getAutoscalingAlgorithm();

    public void setAutoscalingAlgorithm(AutoscalingAlgorithmType var1);

    @Description(value="[Experimental] The maximum number of workers to use when using workerpool autoscaling. If left unspecified, the Dataflow service will compute a ceiling.")
    @Experimental(value=Experimental.Kind.AUTOSCALING)
    public int getMaxNumWorkers();

    public void setMaxNumWorkers(int var1);

    @Description(value="Remote worker disk size, in gigabytes, or 0 to use the default size.")
    public int getDiskSizeGb();

    public void setDiskSizeGb(int var1);

    @Description(value="GCE network for launching workers. Default is up to the Dataflow service.")
    public String getNetwork();

    public void setNetwork(String var1);

    @Description(value="GCE availability zone for launching workers. Default is up to the Dataflow service.")
    public String getZone();

    public void setZone(String var1);

    @Description(value="Machine type to create Dataflow worker VMs as. See https://cloud.google.com/compute/docs/machine-types for a list of valid options. If unset, the Dataflow service will choose a reasonable default.")
    public String getWorkerMachineType();

    public void setWorkerMachineType(String var1);

    @Description(value="The teardown policy for the VMs. By default this is left unset and the service sets the default policy.")
    public TeardownPolicy getTeardownPolicy();

    public void setTeardownPolicy(TeardownPolicy var1);

    @Description(value="Files to stage on GCS and make available to workers. Files are placed on the worker's classpath. The default value is all files from the classpath.")
    @JsonIgnore
    public List<String> getFilesToStage();

    public void setFilesToStage(List<String> var1);

    @Description(value="Specifies what type of persistent disk should be used.")
    public String getWorkerDiskType();

    public void setWorkerDiskType(String var1);

    public static enum TeardownPolicy {
        TEARDOWN_ALWAYS("TEARDOWN_ALWAYS"),
        TEARDOWN_NEVER("TEARDOWN_NEVER");

        private final String teardownPolicy;

        private TeardownPolicy(String teardownPolicy) {
            this.teardownPolicy = teardownPolicy;
        }

        public String getTeardownPolicyName() {
            return this.teardownPolicy;
        }
    }

    @Experimental(value=Experimental.Kind.AUTOSCALING)
    public static enum AutoscalingAlgorithmType {
        NONE("AUTOSCALING_ALGORITHM_NONE"),
        BASIC("AUTOSCALING_ALGORITHM_BASIC"),
        THROUGHPUT_BASED("AUTOSCALING_ALGORITHM_BASIC");

        private final String algorithm;

        private AutoscalingAlgorithmType(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }
}

