/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsFactory;
import com.google.cloud.dataflow.sdk.options.ProxyInvocationHandler;
import com.google.cloud.dataflow.sdk.options.Validation;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Collections2;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Ordering;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.TreeMultimap;
import com.google.cloud.dataflow.sdk.util.common.ReflectHelpers;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;

public class PipelineOptionsValidator {
    public static <T extends PipelineOptions> T validate(Class<T> klass, PipelineOptions options) {
        Preconditions.checkNotNull(klass);
        Preconditions.checkNotNull(options);
        Preconditions.checkArgument(Proxy.isProxyClass(options.getClass()));
        Preconditions.checkArgument(Proxy.getInvocationHandler(options) instanceof ProxyInvocationHandler);
        T asClassOptions = options.as(klass);
        ProxyInvocationHandler handler = (ProxyInvocationHandler)Proxy.getInvocationHandler(asClassOptions);
        TreeMultimap requiredGroups = TreeMultimap.create(Ordering.natural(), PipelineOptionsFactory.MethodNameComparator.INSTANCE);
        for (Method method : ReflectHelpers.getClosureOfMethodsOnInterface(klass)) {
            Validation.Required requiredAnnotation = method.getAnnotation(Validation.Required.class);
            if (requiredAnnotation == null) continue;
            if (requiredAnnotation.groups().length > 0) {
                for (String requiredGroup : requiredAnnotation.groups()) {
                    requiredGroups.put(requiredGroup, method);
                }
                continue;
            }
            String string = String.valueOf(method);
            String string2 = PipelineOptionsValidator.getDescription(method);
            Preconditions.checkArgument(handler.invoke(asClassOptions, method, null) != null, new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Missing required value for [").append(string).append(", \"").append(string2).append("\"]. ").toString());
        }
        for (String requiredGroup : requiredGroups.keySet()) {
            if (PipelineOptionsValidator.verifyGroup(handler, asClassOptions, requiredGroups.get(requiredGroup))) continue;
            String string = String.valueOf(Collections2.transform(requiredGroups.get(requiredGroup), ReflectHelpers.METHOD_FORMATTER));
            String string3 = String.valueOf(klass.getSimpleName());
            throw new IllegalArgumentException(new StringBuilder(127 + String.valueOf(requiredGroup).length() + String.valueOf(string).length() + String.valueOf(string3).length()).append("Missing required value for group [").append(requiredGroup).append("]. At least one of the following properties ").append(string).append(" required. Run with --help=").append(string3).append(" for more information.").toString());
        }
        return asClassOptions;
    }

    private static boolean verifyGroup(ProxyInvocationHandler handler, PipelineOptions options, Collection<Method> requiredGroup) {
        for (Method m : requiredGroup) {
            if (handler.invoke(options, m, null) == null) continue;
            return true;
        }
        return false;
    }

    private static String getDescription(Method method) {
        Description description = method.getAnnotation(Description.class);
        return description == null ? "" : description.value();
    }
}

