/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.cloud.dataflow.sdk.options.Default;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsFactory;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Defaults;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Function;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ClassToInstanceMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.FluentIterable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.MutableClassToInstanceMap;
import com.google.cloud.dataflow.sdk.util.InstanceBuilder;
import com.google.cloud.dataflow.sdk.util.common.ReflectHelpers;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class ProxyInvocationHandler
implements InvocationHandler {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final int hashCode = (int)(Math.random() * 2.147483647E9);
    private final Set<Class<? extends PipelineOptions>> knownInterfaces;
    private final ClassToInstanceMap<PipelineOptions> interfaceToProxyCache;
    private final Map<String, Object> options;
    private final Map<String, JsonNode> jsonOptions;
    private final Map<String, String> gettersToPropertyNames;
    private final Map<String, String> settersToPropertyNames;

    ProxyInvocationHandler(Map<String, Object> options) {
        this(options, Maps.newHashMap());
    }

    private ProxyInvocationHandler(Map<String, Object> options, Map<String, JsonNode> jsonOptions) {
        this.options = options;
        this.jsonOptions = jsonOptions;
        this.knownInterfaces = new HashSet<Class<? extends PipelineOptions>>(PipelineOptionsFactory.getRegisteredOptions());
        this.gettersToPropertyNames = Maps.newHashMap();
        this.settersToPropertyNames = Maps.newHashMap();
        this.interfaceToProxyCache = MutableClassToInstanceMap.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (args == null && "toString".equals(method.getName())) {
            return this.toString();
        }
        if (args != null && args.length == 1 && "equals".equals(method.getName())) {
            return this.equals(args[0]);
        }
        if (args == null && "hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if (args != null && "as".equals(method.getName()) && args[0] instanceof Class) {
            Class clazz = (Class)args[0];
            return this.as(clazz);
        }
        if (args != null && "cloneAs".equals(method.getName()) && args[0] instanceof Class) {
            Class clazz = (Class)args[0];
            return this.cloneAs(proxy, clazz);
        }
        String methodName = method.getName();
        Object object = this;
        synchronized (object) {
            if (this.gettersToPropertyNames.keySet().contains(methodName)) {
                String propertyName = this.gettersToPropertyNames.get(methodName);
                if (!this.options.containsKey(propertyName)) {
                    Object value = this.jsonOptions.containsKey(propertyName) ? this.getValueFromJson(propertyName, method) : this.getDefault((PipelineOptions)proxy, method);
                    this.options.put(propertyName, value);
                }
                return this.options.get(propertyName);
            }
            if (this.settersToPropertyNames.containsKey(methodName)) {
                this.options.put(this.settersToPropertyNames.get(methodName), args[0]);
                return Void.TYPE;
            }
        }
        object = String.valueOf(method);
        String string = String.valueOf(Arrays.toString(args));
        throw new RuntimeException(new StringBuilder(39 + String.valueOf(object).length() + String.valueOf(string).length()).append("Unknown method [").append((String)object).append("] invoked with args [").append(string).append("].").toString());
    }

    synchronized <T extends PipelineOptions> T as(Class<T> iface) {
        Preconditions.checkNotNull(iface);
        Preconditions.checkArgument(iface.isInterface());
        if (!this.interfaceToProxyCache.containsKey(iface)) {
            PipelineOptionsFactory.Registration<T> registration = PipelineOptionsFactory.validateWellFormed(iface, this.knownInterfaces);
            List<PropertyDescriptor> propertyDescriptors = registration.getPropertyDescriptors();
            Class<T> proxyClass = registration.getProxyClass();
            this.gettersToPropertyNames.putAll(ProxyInvocationHandler.generateGettersToPropertyNames(propertyDescriptors));
            this.settersToPropertyNames.putAll(ProxyInvocationHandler.generateSettersToPropertyNames(propertyDescriptors));
            this.knownInterfaces.add(iface);
            this.interfaceToProxyCache.putInstance(iface, InstanceBuilder.ofType(proxyClass).fromClass(proxyClass).withArg(InvocationHandler.class, this).build());
        }
        return (T)((PipelineOptions)this.interfaceToProxyCache.getInstance(iface));
    }

    synchronized <T extends PipelineOptions> T cloneAs(Object proxy, Class<T> iface) {
        PipelineOptions clonedOptions;
        try {
            clonedOptions = (PipelineOptions)MAPPER.readValue(MAPPER.writeValueAsBytes(proxy), PipelineOptions.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize the pipeline options to JSON.", e);
        }
        for (Class<? extends PipelineOptions> knownIface : this.knownInterfaces) {
            clonedOptions.as(knownIface);
        }
        return clonedOptions.as(iface);
    }

    public boolean equals(Object obj) {
        return obj != null && (obj instanceof ProxyInvocationHandler && this == obj || Proxy.isProxyClass(obj.getClass()) && this == Proxy.getInvocationHandler(obj));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public synchronized String toString() {
        TreeMap<String, Object> sortedOptions = new TreeMap<String, Object>();
        sortedOptions.putAll(this.jsonOptions);
        sortedOptions.putAll(this.options);
        StringBuilder b = new StringBuilder();
        b.append("Current Settings:\n");
        for (Map.Entry entry : sortedOptions.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = String.valueOf(entry.getValue());
            b.append(new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(string2).length()).append("  ").append(string).append(": ").append(string2).append("\n").toString());
        }
        return b.toString();
    }

    private Object getValueFromJson(String propertyName, Method method) {
        try {
            JavaType type = MAPPER.getTypeFactory().constructType(method.getGenericReturnType());
            JsonNode jsonNode = this.jsonOptions.get(propertyName);
            return MAPPER.readValue(jsonNode.toString(), type);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse representation", e);
        }
    }

    private Object getDefault(PipelineOptions proxy, Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof Default.Class) {
                return ((Default.Class)annotation).value();
            }
            if (annotation instanceof Default.String) {
                return ((Default.String)annotation).value();
            }
            if (annotation instanceof Default.Boolean) {
                return ((Default.Boolean)annotation).value();
            }
            if (annotation instanceof Default.Character) {
                return Character.valueOf(((Default.Character)annotation).value());
            }
            if (annotation instanceof Default.Byte) {
                return ((Default.Byte)annotation).value();
            }
            if (annotation instanceof Default.Short) {
                return ((Default.Short)annotation).value();
            }
            if (annotation instanceof Default.Integer) {
                return ((Default.Integer)annotation).value();
            }
            if (annotation instanceof Default.Long) {
                return ((Default.Long)annotation).value();
            }
            if (annotation instanceof Default.Float) {
                return Float.valueOf(((Default.Float)annotation).value());
            }
            if (annotation instanceof Default.Double) {
                return ((Default.Double)annotation).value();
            }
            if (annotation instanceof Default.Enum) {
                return Enum.valueOf(method.getReturnType(), ((Default.Enum)annotation).value());
            }
            if (!(annotation instanceof Default.InstanceFactory)) continue;
            return InstanceBuilder.ofType(((Default.InstanceFactory)annotation).value()).build().create(proxy);
        }
        return Defaults.defaultValue(method.getReturnType());
    }

    private static Map<String, String> generateGettersToPropertyNames(List<PropertyDescriptor> propertyDescriptors) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            if (descriptor.getReadMethod() == null) continue;
            builder.put(descriptor.getReadMethod().getName(), descriptor.getName());
        }
        return builder.build();
    }

    private static Map<String, String> generateSettersToPropertyNames(List<PropertyDescriptor> propertyDescriptors) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            if (descriptor.getWriteMethod() == null) continue;
            builder.put(descriptor.getWriteMethod().getName(), descriptor.getName());
        }
        return builder.build();
    }

    static class Deserializer
    extends JsonDeserializer<PipelineOptions> {
        Deserializer() {
        }

        public PipelineOptions deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectNode objectNode = (ObjectNode)jp.readValueAsTree();
            ObjectNode optionsNode = (ObjectNode)objectNode.get("options");
            HashMap fields = Maps.newHashMap();
            Iterator iterator = optionsNode.fields();
            while (iterator.hasNext()) {
                Map.Entry field = (Map.Entry)iterator.next();
                fields.put(field.getKey(), field.getValue());
            }
            PipelineOptions options = new ProxyInvocationHandler(Maps.newHashMap(), fields).as(PipelineOptions.class);
            return options;
        }
    }

    static class Serializer
    extends JsonSerializer<PipelineOptions> {
        Serializer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialize(PipelineOptions value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            ProxyInvocationHandler handler;
            ProxyInvocationHandler proxyInvocationHandler = handler = (ProxyInvocationHandler)Proxy.getInvocationHandler(value);
            synchronized (proxyInvocationHandler) {
                HashMap<String, Object> filteredOptions = Maps.newHashMap(handler.options);
                this.removeIgnoredOptions(handler.knownInterfaces, filteredOptions);
                this.ensureSerializable(handler.knownInterfaces, filteredOptions);
                HashMap<String, Object> serializableOptions = Maps.newHashMap(handler.jsonOptions);
                serializableOptions.putAll(filteredOptions);
                jgen.writeStartObject();
                jgen.writeFieldName("options");
                jgen.writeObject(serializableOptions);
                jgen.writeEndObject();
            }
        }

        private void removeIgnoredOptions(Set<Class<? extends PipelineOptions>> interfaces, Map<String, Object> options) {
            ImmutableSet<String> jsonIgnoreMethodNames = FluentIterable.from(ReflectHelpers.getClosureOfMethodsOnInterfaces(interfaces)).filter(PipelineOptionsFactory.JsonIgnorePredicate.INSTANCE).transform(new Function<Method, String>(){

                @Override
                public String apply(Method input) {
                    return input.getName();
                }
            }).toSet();
            for (PropertyDescriptor descriptor : PipelineOptionsFactory.getPropertyDescriptors(interfaces)) {
                if (!jsonIgnoreMethodNames.contains(descriptor.getReadMethod().getName())) continue;
                options.remove(descriptor.getName());
            }
        }

        private void ensureSerializable(Set<Class<? extends PipelineOptions>> interfaces, Map<String, Object> options) throws IOException {
            HashMap<String, Type> propertyToReturnType = Maps.newHashMap();
            for (PropertyDescriptor propertyDescriptor : PipelineOptionsFactory.getPropertyDescriptors(interfaces)) {
                if (propertyDescriptor.getReadMethod() == null) continue;
                propertyToReturnType.put(propertyDescriptor.getName(), propertyDescriptor.getReadMethod().getGenericReturnType());
            }
            for (Map.Entry entry : options.entrySet()) {
                try {
                    String serializedValue = MAPPER.writeValueAsString(entry.getValue());
                    JavaType type = MAPPER.getTypeFactory().constructType((Type)propertyToReturnType.get(entry.getKey()));
                    MAPPER.readValue(serializedValue, type);
                }
                catch (Exception e) {
                    throw new IOException(String.format("Failed to serialize and deserialize property '%s' with value '%s'", entry.getKey(), entry.getValue()), e);
                }
            }
        }
    }
}

