/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.HashMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.SetMultimap;
import com.google.cloud.dataflow.sdk.runners.TransformTreeNode;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.AggregatorRetriever;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class AggregatorPipelineExtractor {
    private final Pipeline pipeline;

    public AggregatorPipelineExtractor(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public Map<Aggregator<?, ?>, Collection<PTransform<?, ?>>> getAggregatorSteps() {
        HashMultimap<Aggregator<?, ?>, PTransform<?, ?>> aggregatorSteps = HashMultimap.create();
        this.pipeline.traverseTopologically(new AggregatorVisitor(aggregatorSteps));
        return aggregatorSteps.asMap();
    }

    private static class AggregatorVisitor
    implements Pipeline.PipelineVisitor {
        private final SetMultimap<Aggregator<?, ?>, PTransform<?, ?>> aggregatorSteps;

        public AggregatorVisitor(SetMultimap<Aggregator<?, ?>, PTransform<?, ?>> aggregatorSteps) {
            this.aggregatorSteps = aggregatorSteps;
        }

        @Override
        public void enterCompositeTransform(TransformTreeNode node) {
        }

        @Override
        public void leaveCompositeTransform(TransformTreeNode node) {
        }

        @Override
        public void visitTransform(TransformTreeNode node) {
            PTransform<?, ?> transform = node.getTransform();
            this.addStepToAggregators(transform, this.getAggregators(transform));
        }

        private Collection<Aggregator<?, ?>> getAggregators(PTransform<?, ?> transform) {
            if (transform != null) {
                if (transform instanceof ParDo.Bound) {
                    return AggregatorRetriever.getAggregators(((ParDo.Bound)transform).getFn());
                }
                if (transform instanceof ParDo.BoundMulti) {
                    return AggregatorRetriever.getAggregators(((ParDo.BoundMulti)transform).getFn());
                }
            }
            return Collections.emptyList();
        }

        private void addStepToAggregators(PTransform<?, ?> transform, Collection<Aggregator<?, ?>> aggregators) {
            for (Aggregator<?, ?> aggregator : aggregators) {
                this.aggregatorSteps.put(aggregator, transform);
            }
        }

        @Override
        public void visitValue(PValue value, TransformTreeNode producer) {
        }
    }
}

