/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.dataflow;

import com.google.api.client.json.JsonFactory;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.dataflow.sdk.coders.TableRowJsonCoder;
import com.google.cloud.dataflow.sdk.io.BigQueryIO;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineTranslator;
import com.google.cloud.dataflow.sdk.util.Transport;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryIOTranslator {
    private static final JsonFactory JSON_FACTORY = Transport.getJsonFactory();
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryIOTranslator.class);

    public static class WriteTranslator
    implements DataflowPipelineTranslator.TransformTranslator<BigQueryIO.Write.Bound> {
        @Override
        public void translate(BigQueryIO.Write.Bound transform, DataflowPipelineTranslator.TranslationContext context) {
            if (context.getPipelineOptions().isStreaming()) {
                throw new AssertionError((Object)"BigQueryIO is specified to use streaming write in batch mode.");
            }
            TableReference table = transform.getTable();
            context.addStep(transform, "ParallelWrite");
            context.addInput("format", "bigquery");
            context.addInput("table", table.getTableId());
            context.addInput("dataset", table.getDatasetId());
            if (table.getProjectId() != null) {
                context.addInput("project", table.getProjectId());
            }
            if (transform.getSchema() != null) {
                try {
                    context.addInput("schema", JSON_FACTORY.toString((Object)transform.getSchema()));
                }
                catch (IOException exn) {
                    throw new IllegalArgumentException("Invalid table schema.", exn);
                }
            }
            context.addInput("create_disposition", transform.getCreateDisposition().name());
            context.addInput("write_disposition", transform.getWriteDisposition().name());
            context.addEncodingInput(WindowedValue.getValueOnlyCoder(TableRowJsonCoder.of()));
            context.addInput("parallel_input", context.getInput(transform));
        }
    }

    public static class ReadTranslator
    implements DataflowPipelineTranslator.TransformTranslator<BigQueryIO.Read.Bound> {
        @Override
        public void translate(BigQueryIO.Read.Bound transform, DataflowPipelineTranslator.TranslationContext context) {
            context.addStep(transform, "ParallelRead");
            context.addInput("format", "bigquery");
            if (transform.getQuery() != null) {
                context.addInput("bigquery_query", transform.getQuery());
            } else {
                TableReference table = transform.getTable();
                if (table.getProjectId() == null) {
                    String projectIdFromOptions = context.getPipelineOptions().getProject();
                    LOG.warn(String.format("No project specified for BigQuery table \"%1$s.%2$s\". Assuming it is in \"%3$s\". If the table is in a different project please specify it as a part of the BigQuery table definition.", table.getDatasetId(), table.getDatasetId(), table.getTableId(), projectIdFromOptions));
                    table.setProjectId(projectIdFromOptions);
                }
                context.addInput("table", table.getTableId());
                context.addInput("dataset", table.getDatasetId());
                if (table.getProjectId() != null) {
                    context.addInput("project", table.getProjectId());
                }
            }
            context.addValueOnlyOutput("output", context.getOutput(transform));
        }
    }
}

