/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.dataflow;

import com.google.api.services.dataflow.model.MetricStructuredName;
import com.google.api.services.dataflow.model.MetricUpdate;
import com.google.cloud.dataflow.sdk.runners.dataflow.DataflowAggregatorTransforms;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataflowMetricUpdateExtractor {
    private static final String STEP_NAME_CONTEXT_KEY = "step";

    private DataflowMetricUpdateExtractor() {
    }

    public static <OutputT> Map<String, OutputT> fromMetricUpdates(Aggregator<?, OutputT> aggregator, DataflowAggregatorTransforms aggregatorTransforms, List<MetricUpdate> metricUpdates) {
        HashMap<String, OutputT> results = new HashMap<String, OutputT>();
        if (metricUpdates == null) {
            return results;
        }
        String aggregatorName = aggregator.getName();
        Collection<String> aggregatorSteps = aggregatorTransforms.getAggregatorStepNames(aggregator);
        for (MetricUpdate metricUpdate : metricUpdates) {
            MetricStructuredName metricStructuredName = metricUpdate.getName();
            Map context = metricStructuredName.getContext();
            if (!metricStructuredName.getName().equals(aggregatorName) || context == null || !aggregatorSteps.contains(context.get(STEP_NAME_CONTEXT_KEY))) continue;
            AppliedPTransform<?, ?, ?> transform = aggregatorTransforms.getAppliedTransformForStepName((String)context.get(STEP_NAME_CONTEXT_KEY));
            String fullName = transform.getFullName();
            results.put(fullName, DataflowMetricUpdateExtractor.toValue(aggregator, metricUpdate));
        }
        return results;
    }

    private static <OutputT> OutputT toValue(Aggregator<?, OutputT> aggregator, MetricUpdate metricUpdate) {
        Combine.CombineFn<?, ?, OutputT> combineFn = aggregator.getCombineFn();
        Class<OutputT> outputType = combineFn.getOutputType().getRawType();
        if (outputType.equals(Long.class)) {
            Long asLong = DataflowMetricUpdateExtractor.toNumber(metricUpdate).longValue();
            return (OutputT)asLong;
        }
        if (outputType.equals(Integer.class)) {
            Integer asInt = DataflowMetricUpdateExtractor.toNumber(metricUpdate).intValue();
            return (OutputT)asInt;
        }
        if (outputType.equals(Double.class)) {
            Double asDouble = DataflowMetricUpdateExtractor.toNumber(metricUpdate).doubleValue();
            return (OutputT)asDouble;
        }
        String string = String.valueOf(outputType);
        String string2 = String.valueOf(aggregator);
        throw new UnsupportedOperationException(new StringBuilder(39 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unsupported Output Type ").append(string).append(" in aggregator ").append(string2).toString());
    }

    private static Number toNumber(MetricUpdate update) {
        if (update.getScalar() instanceof Number) {
            return (Number)update.getScalar();
        }
        String string = String.valueOf(update);
        throw new IllegalArgumentException(new StringBuilder(45 + String.valueOf(string).length()).append("Metric Update ").append(string).append(" does not have a numeric scalar").toString());
    }
}

