/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.coders.AvroCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.runners.worker.AvroReader;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.common.worker.AbstractBoundedReaderIterator;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;

public class AvroByteReader<T>
extends Reader<T> {
    final AvroReader<ByteBuffer> avroReader;
    final Coder<T> coder;
    private final Schema schema = Schema.create((Schema.Type)Schema.Type.BYTES);

    public AvroByteReader(String filename, @Nullable Long startPosition, @Nullable Long endPosition, Coder<T> coder) {
        this.coder = coder;
        this.avroReader = new AvroReader<ByteBuffer>(filename, startPosition, endPosition, WindowedValue.getValueOnlyCoder(AvroCoder.of(ByteBuffer.class, this.schema)));
    }

    @Override
    public Reader.ReaderIterator<T> iterator() throws IOException {
        return new AvroByteFileIterator();
    }

    class AvroByteFileIterator
    extends AbstractBoundedReaderIterator<T> {
        private final Reader.ReaderIterator<WindowedValue<ByteBuffer>> avroFileIterator;

        public AvroByteFileIterator() throws IOException {
            this.avroFileIterator = AvroByteReader.this.avroReader.iterator((DatumReader<ByteBuffer>)new GenericDatumReader(AvroByteReader.this.schema));
        }

        @Override
        protected boolean hasNextImpl() throws IOException {
            return this.avroFileIterator.hasNext();
        }

        @Override
        protected T nextImpl() throws IOException {
            ByteBuffer inBuffer = this.avroFileIterator.next().getValue();
            byte[] encodedElem = new byte[inBuffer.remaining()];
            inBuffer.get(encodedElem);
            assert (inBuffer.remaining() == 0);
            inBuffer.clear();
            AvroByteReader.this.notifyElementRead(encodedElem.length);
            return CoderUtils.decodeFromByteArray(AvroByteReader.this.coder, encodedElem);
        }

        @Override
        public void close() throws IOException {
            this.avroFileIterator.close();
        }
    }
}

