/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.dataflow.sdk.options.BigQueryOptions;
import com.google.cloud.dataflow.sdk.util.BigQueryTableRowIterator;
import com.google.cloud.dataflow.sdk.util.Transport;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.common.worker.AbstractBoundedReaderIterator;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.io.IOException;

public class BigQueryReader
extends Reader<WindowedValue<TableRow>> {
    final TableReference tableRef;
    final BigQueryOptions bigQueryOptions;
    final Bigquery bigQueryClient;
    final String query;
    final String projectId;

    public BigQueryReader(BigQueryOptions bigQueryOptions, TableReference tableRef) {
        this.bigQueryOptions = bigQueryOptions;
        this.tableRef = tableRef;
        this.bigQueryClient = null;
        this.query = null;
        this.projectId = null;
    }

    public BigQueryReader(BigQueryOptions bigQueryOptions, String query, String projectId) {
        this.bigQueryOptions = bigQueryOptions;
        this.tableRef = null;
        this.bigQueryClient = null;
        this.query = query;
        this.projectId = projectId;
    }

    public BigQueryReader(Bigquery bigQueryClient, TableReference tableRef) {
        this.bigQueryOptions = null;
        this.tableRef = tableRef;
        this.bigQueryClient = bigQueryClient;
        this.query = null;
        this.projectId = null;
    }

    public BigQueryReader(Bigquery bigQueryClient, String query, String projectId) {
        this.bigQueryOptions = null;
        this.tableRef = null;
        this.bigQueryClient = bigQueryClient;
        this.query = query;
        this.projectId = projectId;
    }

    @Override
    public Reader.ReaderIterator<WindowedValue<TableRow>> iterator() throws IOException {
        if (this.tableRef != null) {
            return new BigQueryReaderIterator(this.bigQueryClient != null ? this.bigQueryClient : Transport.newBigQueryClient(this.bigQueryOptions).build(), this.tableRef);
        }
        return new BigQueryReaderIterator(this.bigQueryClient != null ? this.bigQueryClient : Transport.newBigQueryClient(this.bigQueryOptions).build(), this.query, this.projectId);
    }

    class BigQueryReaderIterator
    extends AbstractBoundedReaderIterator<WindowedValue<TableRow>> {
        private BigQueryTableRowIterator rowIterator;

        public BigQueryReaderIterator(Bigquery bigQueryClient, TableReference tableRef) {
            this.rowIterator = new BigQueryTableRowIterator(bigQueryClient, tableRef);
        }

        public BigQueryReaderIterator(Bigquery bigQueryClient, String query, String projectId) {
            this.rowIterator = new BigQueryTableRowIterator(bigQueryClient, query, projectId);
        }

        @Override
        protected boolean hasNextImpl() {
            return this.rowIterator.hasNext();
        }

        @Override
        protected WindowedValue<TableRow> nextImpl() throws IOException {
            return WindowedValue.valueInGlobalWindow(this.rowIterator.next());
        }

        @Override
        public Reader.Progress getProgress() {
            return null;
        }

        @Override
        public Reader.DynamicSplitResult requestDynamicSplit(Reader.DynamicSplitRequest splitRequest) {
            return null;
        }

        @Override
        public void close() throws IOException {
            this.rowIterator.close();
        }
    }
}

