/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Throwables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.cache.Cache;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.PCollectionViewWindow;
import com.google.cloud.dataflow.sdk.util.Sized;
import com.google.cloud.dataflow.sdk.util.SizedSideInputReader;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

final class CachingSideInputReader
extends SizedSideInputReader.Defaults
implements SizedSideInputReader {
    private SizedSideInputReader subReader;
    private Cache<PCollectionViewWindow<?>, Sized<Object>> cache;

    private CachingSideInputReader(SizedSideInputReader subReader, Cache<PCollectionViewWindow<?>, Sized<Object>> cache) {
        this.subReader = subReader;
        this.cache = cache;
    }

    public static CachingSideInputReader of(SizedSideInputReader subReader, Cache<PCollectionViewWindow<?>, Sized<Object>> cache) {
        return new CachingSideInputReader(subReader, cache);
    }

    @Override
    public <T> boolean contains(PCollectionView<T> view) {
        return this.subReader.contains(view);
    }

    @Override
    public boolean isEmpty() {
        return this.subReader.isEmpty();
    }

    @Override
    public <T> Sized<T> getSized(final PCollectionView<T> view, final BoundedWindow window) {
        PCollectionViewWindow<T> cacheKey = PCollectionViewWindow.of(view, window);
        try {
            Sized<Object> sideInputContents = this.cache.get(cacheKey, new Callable<Sized<Object>>(){

                @Override
                public Sized<Object> call() {
                    Sized<Object> value = CachingSideInputReader.this.subReader.getSized(view, window);
                    return value;
                }
            });
            return sideInputContents;
        }
        catch (UncheckedExecutionException | ExecutionException exc) {
            throw Throwables.propagate(exc.getCause());
        }
    }
}

