/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.ByteStreams;
import com.google.cloud.dataflow.sdk.runners.worker.ByteArrayShufflePosition;
import com.google.cloud.dataflow.sdk.runners.worker.ShuffleReader;
import com.google.cloud.dataflow.sdk.util.common.worker.ShuffleBatchReader;
import com.google.cloud.dataflow.sdk.util.common.worker.ShuffleEntry;
import com.google.cloud.dataflow.sdk.util.common.worker.ShufflePosition;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;

final class ChunkingShuffleBatchReader
implements ShuffleBatchReader {
    private ShuffleReader reader;

    public ChunkingShuffleBatchReader(ShuffleReader reader) {
        this.reader = reader;
    }

    @Override
    public ShuffleBatchReader.Batch read(@Nullable ShufflePosition startShufflePosition, @Nullable ShufflePosition endShufflePosition) throws IOException {
        byte[] startPosition = ByteArrayShufflePosition.getPosition(startShufflePosition);
        byte[] endPosition = ByteArrayShufflePosition.getPosition(endShufflePosition);
        ShuffleReader.ReadChunkResult result = this.reader.readIncludingPosition(startPosition, endPosition);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(result.chunk));
        ArrayList<ShuffleEntry> entries = new ArrayList<ShuffleEntry>();
        while (input.available() > 0) {
            entries.add(ChunkingShuffleBatchReader.getShuffleEntry(input));
        }
        return new ShuffleBatchReader.Batch(entries, result.nextStartPosition == null ? null : ByteArrayShufflePosition.of(result.nextStartPosition));
    }

    static ShuffleEntry getShuffleEntry(DataInputStream input) throws IOException {
        byte[] position = ChunkingShuffleBatchReader.getFixedLengthPrefixedByteArray(input);
        byte[] key = ChunkingShuffleBatchReader.getFixedLengthPrefixedByteArray(input);
        byte[] skey = ChunkingShuffleBatchReader.getFixedLengthPrefixedByteArray(input);
        byte[] value = ChunkingShuffleBatchReader.getFixedLengthPrefixedByteArray(input);
        return new ShuffleEntry(position, key, skey, value);
    }

    static byte[] getFixedLengthPrefixedByteArray(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        if (length < 0) {
            throw new IOException(new StringBuilder(27).append("invalid length: ").append(length).toString());
        }
        byte[] data = new byte[length];
        ByteStreams.readFully(dataInputStream, data);
        return data;
    }
}

