/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.ApproximateProgress;
import com.google.api.services.dataflow.model.ConcatPosition;
import com.google.api.services.dataflow.model.Position;
import com.google.api.services.dataflow.model.Source;
import com.google.cloud.dataflow.sdk.io.range.OffsetRangeTracker;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.runners.worker.ReaderFactory;
import com.google.cloud.dataflow.sdk.runners.worker.SourceTranslationUtils;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.AbstractBoundedReaderIterator;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatReader<T>
extends Reader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ConcatReader.class);
    public static final String SOURCE_NAME = "ConcatSource";
    private final List<Source> sources;
    private final PipelineOptions options;
    private final ExecutionContext executionContext;
    private final CounterSet.AddCounterMutator addCounterMutator;
    private final String operationName;
    private final ReaderFactory.Registry registry;

    public ConcatReader(ReaderFactory.Registry registry, PipelineOptions options, ExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, String operationName, List<Source> sources) {
        Preconditions.checkNotNull(sources);
        this.registry = registry;
        this.sources = sources;
        this.options = options;
        this.executionContext = executionContext;
        this.addCounterMutator = addCounterMutator;
        this.operationName = operationName;
    }

    public Iterator<Source> getSources() {
        return this.sources.iterator();
    }

    @Override
    public Reader.ReaderIterator<T> iterator() throws IOException {
        return new ConcatIterator(this.registry, this.options, this.executionContext, this.addCounterMutator, this.operationName, this.sources);
    }

    private static class ConcatIterator<T>
    extends AbstractBoundedReaderIterator<T> {
        private int currentIteratorIndex = -1;
        private Reader.ReaderIterator<T> currentIterator = null;
        private final List<Source> sources;
        private final PipelineOptions options;
        private final ExecutionContext executionContext;
        private final CounterSet.AddCounterMutator addCounterMutator;
        private final String operationName;
        private final OffsetRangeTracker rangeTracker;
        private boolean isAtFirstRecordInCurrentSource = true;
        private final ReaderFactory.Registry registry;

        public ConcatIterator(ReaderFactory.Registry registry, PipelineOptions options, ExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, String operationName, List<Source> sources) {
            this.registry = registry;
            this.sources = sources;
            this.options = options;
            this.executionContext = executionContext;
            this.addCounterMutator = addCounterMutator;
            this.operationName = operationName;
            this.rangeTracker = new OffsetRangeTracker(0L, sources.size());
        }

        @Override
        protected boolean hasNextImpl() throws IOException {
            while (this.currentIterator == null || !this.currentIterator.hasNext()) {
                if (this.currentIterator != null) {
                    this.currentIterator.close();
                }
                ++this.currentIteratorIndex;
                if (this.currentIteratorIndex == this.sources.size()) {
                    return false;
                }
                Source currentSource = this.sources.get(this.currentIteratorIndex);
                try {
                    Reader<?> currentReader = this.registry.create(currentSource, this.options, this.executionContext, this.addCounterMutator, this.operationName);
                    this.currentIterator = currentReader.iterator();
                    this.isAtFirstRecordInCurrentSource = true;
                }
                catch (Exception e) {
                    String string = String.valueOf(currentSource);
                    throw new IOException(new StringBuilder(38 + String.valueOf(string).length()).append("Failed to create a reader for source: ").append(string).toString(), e);
                }
            }
            return this.rangeTracker.tryReturnRecordAt(this.isAtFirstRecordInCurrentSource, this.currentIteratorIndex);
        }

        @Override
        protected T nextImpl() throws IOException, NoSuchElementException {
            this.isAtFirstRecordInCurrentSource = false;
            return this.currentIterator.next();
        }

        @Override
        public void close() throws IOException {
            if (this.currentIterator != null) {
                this.currentIterator.close();
            }
        }

        @Override
        public Reader.Progress getProgress() {
            if (this.currentIteratorIndex < 0) {
                return null;
            }
            ConcatPosition concatPosition = new ConcatPosition();
            concatPosition.setIndex(Integer.valueOf(this.currentIteratorIndex));
            Reader.Progress progressOfCurrentIterator = this.currentIterator.getProgress();
            if (!(progressOfCurrentIterator instanceof SourceTranslationUtils.DataflowReaderProgress)) {
                String string = String.valueOf(progressOfCurrentIterator);
                throw new IllegalArgumentException(new StringBuilder(123 + String.valueOf(string).length()).append("Cannot process progress ").append(string).append(" since ConcatReader can only handle readers that generate a progress of type ").append("DataflowReaderProgress").toString());
            }
            Position positionOfCurrentIterator = ((SourceTranslationUtils.DataflowReaderProgress)progressOfCurrentIterator).cloudProgress.getPosition();
            if (positionOfCurrentIterator != null) {
                concatPosition.setPosition(positionOfCurrentIterator);
            }
            ApproximateProgress progress = new ApproximateProgress();
            Position currentPosition = new Position();
            currentPosition.setConcatPosition(concatPosition);
            progress.setPosition(currentPosition);
            return SourceTranslationUtils.cloudProgressToReaderProgress(progress);
        }

        @Override
        public Reader.DynamicSplitResult requestDynamicSplit(Reader.DynamicSplitRequest splitRequest) {
            Preconditions.checkNotNull(splitRequest);
            ApproximateProgress splitProgress = SourceTranslationUtils.splitRequestToApproximateProgress(splitRequest);
            Position cloudPosition = splitProgress.getPosition();
            if (cloudPosition == null) {
                LOG.warn("Concat only supports split at a Position. Requested: {}", (Object)splitRequest);
                return null;
            }
            ConcatPosition concatPosition = cloudPosition.getConcatPosition();
            if (concatPosition == null) {
                LOG.warn("ConcatReader only supports split at a ConcatPosition. Requested: {}", (Object)cloudPosition);
                return null;
            }
            if (this.rangeTracker.trySplitAtPosition(concatPosition.getIndex().intValue())) {
                Position positionToSplit = new Position();
                positionToSplit.setConcatPosition(new ConcatPosition().setIndex(Integer.valueOf((int)this.rangeTracker.getStopPosition().longValue())));
                return new Reader.DynamicSplitResultWithPosition(SourceTranslationUtils.cloudPositionToReaderPosition(positionToSplit));
            }
            String string = String.valueOf(splitRequest);
            LOG.debug(new StringBuilder(44 + String.valueOf(string).length()).append("Could not perform the dynamic split request ").append(string).toString());
            return null;
        }
    }
}

