/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.Source;
import com.google.api.services.dataflow.model.SourceMetadata;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.runners.worker.ConcatReader;
import com.google.cloud.dataflow.sdk.runners.worker.ReaderFactory;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ConcatReaderFactory
implements ReaderFactory {
    private final ReaderFactory.Registry registry;

    private ConcatReaderFactory(ReaderFactory.Registry registry) {
        this.registry = registry;
    }

    public static ConcatReaderFactory withDefaultRegistry() {
        return ConcatReaderFactory.withRegistry(ReaderFactory.Registry.defaultRegistry());
    }

    public static ConcatReaderFactory withRegistry(ReaderFactory.Registry registry) {
        return new ConcatReaderFactory(registry);
    }

    @Override
    public Reader<?> create(CloudObject spec, @Nullable Coder<?> coder, @Nullable PipelineOptions options, @Nullable ExecutionContext executionContext, @Nullable CounterSet.AddCounterMutator addCounterMutator, @Nullable String operationName) throws Exception {
        Coder<?> typedCoder = coder;
        return this.createTyped(spec, typedCoder, options, executionContext, addCounterMutator, operationName);
    }

    public <T> Reader<T> createTyped(CloudObject spec, @Nullable Coder<T> coder, @Nullable PipelineOptions options, @Nullable ExecutionContext executionContext, @Nullable CounterSet.AddCounterMutator addCounterMutator, @Nullable String operationName) throws Exception {
        List<Source> sources = ConcatReaderFactory.getSubSources(spec);
        return new ConcatReader(this.registry, options, executionContext, addCounterMutator, operationName, sources);
    }

    private static List<Source> getSubSources(CloudObject spec) throws Exception {
        ArrayList<Source> subSources = new ArrayList<Source>();
        List<Map<String, Object>> subSourceDictionaries = Structs.getListOfMaps((Map<String, Object>)((Object)spec), "sources", null);
        if (subSourceDictionaries == null) {
            return subSources;
        }
        for (Map<String, Object> subSourceDictionary : subSourceDictionaries) {
            subSources.add(ConcatReaderFactory.createSourceFromDictionary(subSourceDictionary));
        }
        return subSources;
    }

    public static Source createSourceFromDictionary(Map<String, Object> dictionary) throws Exception {
        Boolean doesNotNeedSplitting;
        Long estimatedSizeBytes;
        Boolean infinite;
        List<Map<String, Object>> subSourceBaseSpecs;
        Source source = new Source();
        CloudObject subSourceSpec = CloudObject.fromSpec(Structs.getObject(dictionary, "spec"));
        source.setSpec((Map)((Object)subSourceSpec));
        CloudObject subSourceEncoding = CloudObject.fromSpec(Structs.getObject(dictionary, "encoding", null));
        if (subSourceEncoding != null) {
            source.setCodec((Map)((Object)subSourceEncoding));
        }
        if ((subSourceBaseSpecs = Structs.getListOfMaps(dictionary, "base_specs", null)) != null) {
            source.setBaseSpecs(subSourceBaseSpecs);
        }
        SourceMetadata metadata = new SourceMetadata();
        Boolean producesSortedKeys = Structs.getBoolean(dictionary, "produces_sorted_keys", null);
        if (producesSortedKeys != null) {
            metadata.setProducesSortedKeys(producesSortedKeys);
        }
        if ((infinite = Structs.getBoolean(dictionary, "is_infinite", null)) != null) {
            metadata.setInfinite(infinite);
        }
        if ((estimatedSizeBytes = Structs.getLong(dictionary, "estimated_size_bytes", null)) != null) {
            metadata.setEstimatedSizeBytes(estimatedSizeBytes);
        }
        if (producesSortedKeys != null || estimatedSizeBytes != null || infinite != null) {
            source.setMetadata(metadata);
        }
        if ((doesNotNeedSplitting = Structs.getBoolean(dictionary, "does_not_need_splitting", null)) != null) {
            source.setDoesNotNeedSplitting(doesNotNeedSplitting);
        }
        return source;
    }
}

