/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.ApproximateProgress;
import com.google.api.services.dataflow.model.WorkItem;
import com.google.api.services.dataflow.model.WorkItemServiceState;
import com.google.api.services.dataflow.model.WorkItemStatus;
import com.google.cloud.dataflow.sdk.options.DataflowWorkerHarnessOptions;
import com.google.cloud.dataflow.sdk.runners.worker.DataflowWorker;
import com.google.cloud.dataflow.sdk.runners.worker.SourceTranslationUtils;
import com.google.cloud.dataflow.sdk.util.TimeUtil;
import com.google.cloud.dataflow.sdk.util.common.worker.WorkExecutor;
import com.google.cloud.dataflow.sdk.util.common.worker.WorkProgressUpdater;
import javax.annotation.concurrent.NotThreadSafe;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DataflowWorkProgressUpdater
extends WorkProgressUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowWorkProgressUpdater.class);
    private final DataflowWorker.WorkUnitClient workUnitClient;
    private final WorkItem workItem;
    private final DataflowWorkerHarnessOptions options;
    private long nextReportIndex;

    public DataflowWorkProgressUpdater(WorkItem workItem, WorkExecutor worker, DataflowWorker.WorkUnitClient workUnitClient, DataflowWorkerHarnessOptions options) {
        super(worker);
        this.workItem = workItem;
        this.workUnitClient = workUnitClient;
        this.options = options;
        this.nextReportIndex = workItem.getInitialReportIndex();
    }

    @Override
    protected String workString() {
        return DataflowWorker.uniqueId(this.workItem);
    }

    @Override
    protected long getWorkUnitLeaseExpirationTimestamp() {
        return this.getLeaseExpirationTimestamp(this.workItem);
    }

    @Override
    protected long getWorkUnitSuggestedReportingInterval() {
        return TimeUtil.fromCloudDuration(this.workItem.getReportStatusInterval()).getMillis();
    }

    @Override
    protected void reportProgressHelper() throws Exception {
        WorkItemStatus status = DataflowWorker.buildStatus(this.workItem, false, this.worker.getOutputCounters(), this.worker.getOutputMetrics(), this.options, this.worker.getWorkerProgress(), this.dynamicSplitResultToReport, null, null, this.getNextReportIndex(), this.worker.getWorkerStateSamplerInfo());
        status.setRequestedLeaseDuration(TimeUtil.toCloudDuration((ReadableDuration)Duration.millis((long)this.requestedLeaseDurationMs)));
        WorkItemServiceState result = this.workUnitClient.reportWorkItemStatus(status);
        if (result != null) {
            this.dynamicSplitResultToReport = null;
            this.nextReportIndex = result.getNextReportIndex();
            this.progressReportIntervalMs = this.nextProgressReportInterval(TimeUtil.fromCloudDuration(result.getReportStatusInterval()).getMillis(), this.leaseRemainingTime(this.getLeaseExpirationTimestamp(result)));
            ApproximateProgress suggestedStopPoint = result.getSuggestedStopPoint();
            if (suggestedStopPoint != null) {
                LOG.info("Proposing dynamic split of work unit {} at {}", (Object)this.workString(), (Object)suggestedStopPoint);
                this.dynamicSplitResultToReport = this.worker.requestDynamicSplit(SourceTranslationUtils.toDynamicSplitRequest(suggestedStopPoint));
            }
        }
    }

    private long getLeaseExpirationTimestamp(WorkItem workItem) {
        return TimeUtil.fromCloudTime(workItem.getLeaseExpireTime()).getMillis();
    }

    private long getLeaseExpirationTimestamp(WorkItemServiceState workItemServiceState) {
        return TimeUtil.fromCloudTime(workItemServiceState.getLeaseExpireTime()).getMillis();
    }

    long getNextReportIndex() {
        return this.nextReportIndex;
    }
}

