/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.client.util.Preconditions;
import com.google.api.services.dataflow.model.ApproximateProgress;
import com.google.api.services.dataflow.model.Position;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.io.TextIO;
import com.google.cloud.dataflow.sdk.io.range.OffsetRangeTracker;
import com.google.cloud.dataflow.sdk.runners.worker.CopyableSeekableByteChannel;
import com.google.cloud.dataflow.sdk.runners.worker.SourceTranslationUtils;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.IOChannelFactory;
import com.google.cloud.dataflow.sdk.util.IOChannelUtils;
import com.google.cloud.dataflow.sdk.util.common.worker.AbstractBoundedReaderIterator;
import com.google.cloud.dataflow.sdk.util.common.worker.ProgressTracker;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.channels.Channels;
import java.util.Collection;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileBasedReader<T>
extends Reader<T> {
    protected static final int BUF_SIZE = 200;
    protected final String filename;
    @Nullable
    protected final Long startPosition;
    @Nullable
    protected final Long endPosition;
    protected final Coder<T> coder;
    protected final boolean useDefaultBufferSize;
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedReader.class);

    protected FileBasedReader(String filename, @Nullable Long startPosition, @Nullable Long endPosition, Coder<T> coder, boolean useDefaultBufferSize) {
        this.filename = filename;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.coder = coder;
        this.useDefaultBufferSize = useDefaultBufferSize;
    }

    protected abstract Reader.ReaderIterator<T> newReaderIteratorForRangeInFile(IOChannelFactory var1, String var2, long var3, @Nullable Long var5) throws IOException;

    protected abstract Reader.ReaderIterator<T> newReaderIteratorForFiles(IOChannelFactory var1, Collection<String> var2) throws IOException;

    @Override
    public Reader.ReaderIterator<T> iterator() throws IOException {
        IOChannelFactory factory = IOChannelUtils.getFactory(this.filename);
        Collection<String> inputs = factory.match(this.filename);
        if (inputs.isEmpty()) {
            String string = this.filename;
            throw new FileNotFoundException(new StringBuilder(28 + String.valueOf(string).length()).append("No match for file pattern '").append(string).append("'").toString());
        }
        if (this.startPosition != null || this.endPosition != null) {
            if (inputs.size() != 1) {
                String string = String.valueOf(this.startPosition);
                String string2 = String.valueOf(this.endPosition);
                String string3 = this.filename;
                int n = inputs.size();
                throw new IllegalArgumentException(new StringBuilder(153 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Offset range specified: [").append(string).append(", ").append(string2).append("), so ").append("an exact filename was expected, but more than 1 file matched \"").append(string3).append("\" (total ").append(n).append("): apparently a filepattern was given.").toString());
            }
            return this.newReaderIteratorForRangeInFile(factory, inputs.iterator().next(), this.startPosition == null ? 0L : this.startPosition, this.endPosition);
        }
        return this.newReaderIteratorForFiles(factory, inputs);
    }

    protected static class FilenameBasedStreamFactory
    implements DecompressingStreamFactory {
        private String filename;
        private TextIO.CompressionType compressionType;

        public FilenameBasedStreamFactory(String filename, TextIO.CompressionType compressionType) {
            this.filename = filename;
            this.compressionType = compressionType;
        }

        protected TextIO.CompressionType getCompressionTypeForAuto() {
            for (TextIO.CompressionType type : TextIO.CompressionType.values()) {
                if (!type.matches(this.filename) || type == TextIO.CompressionType.AUTO || type == TextIO.CompressionType.UNCOMPRESSED) continue;
                return type;
            }
            return TextIO.CompressionType.UNCOMPRESSED;
        }

        @Override
        public InputStream createInputStream(InputStream inputStream) throws IOException {
            if (this.compressionType == TextIO.CompressionType.AUTO) {
                return this.getCompressionTypeForAuto().createInputStream(inputStream);
            }
            return this.compressionType.createInputStream(inputStream);
        }
    }

    public static interface DecompressingStreamFactory {
        public InputStream createInputStream(InputStream var1) throws IOException;
    }

    protected abstract class FileBasedIterator
    extends AbstractBoundedReaderIterator<T> {
        protected final CopyableSeekableByteChannel seeker;
        protected final PushbackInputStream stream;
        protected final OffsetRangeTracker rangeTracker;
        protected long offset;
        protected final ProgressTracker<Integer> progressTracker;
        protected ByteArrayOutputStream nextElement;
        protected DecompressingStreamFactory compressionStreamFactory;

        FileBasedIterator(CopyableSeekableByteChannel seeker, long startOffset, @Nullable long offset, Long endOffset, ProgressTracker<Integer> progressTracker, DecompressingStreamFactory compressionStreamFactory) throws IOException {
            this.seeker = (CopyableSeekableByteChannel)Preconditions.checkNotNull((Object)seeker);
            this.seeker.position(startOffset);
            this.compressionStreamFactory = compressionStreamFactory;
            InputStream inputStream = compressionStreamFactory.createInputStream(Channels.newInputStream(seeker));
            BufferedInputStream bufferedStream = FileBasedReader.this.useDefaultBufferSize ? new BufferedInputStream(inputStream) : new BufferedInputStream(inputStream, 200);
            this.stream = new PushbackInputStream(bufferedStream, 200);
            long stopOffset = endOffset == null ? Long.MAX_VALUE : endOffset;
            this.rangeTracker = new OffsetRangeTracker(startOffset, stopOffset);
            this.offset = offset;
            this.progressTracker = (ProgressTracker)Preconditions.checkNotNull(progressTracker);
        }

        protected abstract ByteArrayOutputStream readElement() throws IOException;

        @Override
        protected boolean hasNextImpl() throws IOException {
            long startOffset = this.offset;
            ByteArrayOutputStream element = this.readElement();
            if (element != null && this.rangeTracker.tryReturnRecordAt(true, startOffset)) {
                this.nextElement = element;
                this.progressTracker.saw((int)(this.offset - startOffset));
            } else {
                this.nextElement = null;
            }
            return this.nextElement != null;
        }

        @Override
        protected T nextImpl() throws IOException {
            return CoderUtils.decodeFromByteArray(FileBasedReader.this.coder, this.nextElement.toByteArray());
        }

        @Override
        public Reader.Progress getProgress() {
            Position currentPosition = new Position();
            currentPosition.setByteOffset(Long.valueOf(this.offset));
            ApproximateProgress progress = new ApproximateProgress();
            progress.setPosition(currentPosition);
            if (this.rangeTracker.getStopPosition() != Long.MAX_VALUE) {
                progress.setPercentComplete(Float.valueOf((float)this.rangeTracker.getFractionConsumed()));
            }
            return SourceTranslationUtils.cloudProgressToReaderProgress(progress);
        }

        @Override
        public Reader.DynamicSplitResult requestDynamicSplit(Reader.DynamicSplitRequest splitRequest) {
            Preconditions.checkNotNull((Object)splitRequest);
            ApproximateProgress splitProgress = SourceTranslationUtils.splitRequestToApproximateProgress(splitRequest);
            Position splitPosition = splitProgress.getPosition();
            if (splitPosition == null) {
                LOG.warn("FileBasedReader only supports split at a Position. Requested: {}", (Object)splitRequest);
                return null;
            }
            Long splitOffset = splitPosition.getByteOffset();
            if (splitOffset == null) {
                LOG.warn("FileBasedReader only supports split at byte offset. Requested: {}", (Object)splitPosition);
                return null;
            }
            if (this.rangeTracker.trySplitAtPosition(splitOffset)) {
                return new Reader.DynamicSplitResultWithPosition(SourceTranslationUtils.cloudPositionToReaderPosition(splitPosition));
            }
            return null;
        }

        long getEndOffset() {
            return this.rangeTracker.getStopPosition();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }
}

