/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.MultiOutputInfo;
import com.google.api.services.dataflow.model.SideInputInfo;
import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.coders.KvCoder;
import com.google.cloud.dataflow.sdk.coders.ListCoder;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.StreamingOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.runners.worker.DataflowExecutionContext;
import com.google.cloud.dataflow.sdk.runners.worker.ParDoFnBase;
import com.google.cloud.dataflow.sdk.runners.worker.ParDoFnFactory;
import com.google.cloud.dataflow.sdk.runners.worker.StreamingGroupAlsoByWindowsDoFn;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindow;
import com.google.cloud.dataflow.sdk.util.AppliedCombineFn;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.DoFnInfo;
import com.google.cloud.dataflow.sdk.util.GroupAlsoByWindowsDoFn;
import com.google.cloud.dataflow.sdk.util.NullSideInputReader;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import com.google.cloud.dataflow.sdk.util.Serializer;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.ParDoFn;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class GroupAlsoByWindowsParDoFn
extends ParDoFnBase {
    private final DoFn<?, ?> groupAlsoByWindowsDoFn;

    static GroupAlsoByWindowsParDoFn of(PipelineOptions options, DoFn<?, ?> groupAlsoByWindowsDoFn, String stepName, String transformName, DataflowExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) throws Exception {
        return new GroupAlsoByWindowsParDoFn(options, groupAlsoByWindowsDoFn, stepName, transformName, executionContext, addCounterMutator, stateSampler);
    }

    @Override
    protected DoFnInfo<?, ?> getDoFnInfo() {
        return new DoFnInfo(this.groupAlsoByWindowsDoFn, null);
    }

    private static DoFn<?, ?> getGroupAlsoByWindowsDoFn(boolean isStreamingPipeline, WindowingStrategy windowingStrategy, KvCoder kvCoder, @Nullable AppliedCombineFn maybeMergingCombineFn) {
        if (isStreamingPipeline) {
            if (maybeMergingCombineFn == null) {
                return StreamingGroupAlsoByWindowsDoFn.createForIterable(windowingStrategy, kvCoder.getValueCoder());
            }
            return StreamingGroupAlsoByWindowsDoFn.create(windowingStrategy, maybeMergingCombineFn, kvCoder.getKeyCoder());
        }
        if (maybeMergingCombineFn == null) {
            return GroupAlsoByWindowsDoFn.createForIterable(windowingStrategy, kvCoder.getValueCoder());
        }
        return GroupAlsoByWindowsDoFn.create(windowingStrategy, maybeMergingCombineFn, kvCoder.getKeyCoder());
    }

    private static <K, AccumT> AppliedCombineFn<K, AccumT, List<AccumT>, AccumT> makeAppliedMergingFunction(AppliedCombineFn<K, ?, AccumT, ?> appliedFn) {
        MergingKeyedCombineFn<K, AccumT> mergingCombineFn = new MergingKeyedCombineFn<K, AccumT>(appliedFn);
        return AppliedCombineFn.withAccumulatorCoder(mergingCombineFn, ListCoder.of(appliedFn.getAccumulatorCoder()));
    }

    private GroupAlsoByWindowsParDoFn(PipelineOptions options, DoFn<?, ?> groupAlsoByWindowsDoFn, String stepName, String transformName, DataflowExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        super(options, NullSideInputReader.empty(), Arrays.asList("output"), stepName, transformName, executionContext, addCounterMutator, stateSampler);
        this.groupAlsoByWindowsDoFn = groupAlsoByWindowsDoFn;
    }

    static class MergingKeyedCombineFn<K, AccumT>
    extends Combine.KeyedCombineFn<K, AccumT, List<AccumT>, AccumT> {
        final AppliedCombineFn<K, ?, AccumT, ?> appliedCombineFn;

        MergingKeyedCombineFn(AppliedCombineFn<K, ?, AccumT, ?> keyedCombineFn) {
            this.appliedCombineFn = keyedCombineFn;
        }

        @Override
        public List<AccumT> createAccumulator(K key) {
            return new ArrayList();
        }

        @Override
        public List<AccumT> addInput(K key, List<AccumT> accumulator, AccumT input) {
            accumulator.add(input);
            if (accumulator.size() > 1) {
                return this.mergeToSingleton(key, accumulator);
            }
            return accumulator;
        }

        @Override
        public List<AccumT> mergeAccumulators(K key, Iterable<List<AccumT>> accumulators) {
            return this.mergeToSingleton(key, Iterables.concat(accumulators));
        }

        @Override
        public AccumT extractOutput(K key, List<AccumT> accumulator) {
            if (accumulator.size() == 0) {
                return this.appliedCombineFn.getFn().createAccumulator(key);
            }
            return this.appliedCombineFn.getFn().mergeAccumulators(key, accumulator);
        }

        private List<AccumT> mergeToSingleton(K key, Iterable<AccumT> accumulators) {
            ArrayList<AccumT> singleton = new ArrayList<AccumT>();
            singleton.add(this.appliedCombineFn.getFn().mergeAccumulators(key, accumulators));
            return singleton;
        }

        @Override
        public Coder<List<AccumT>> getAccumulatorCoder(CoderRegistry registry, Coder<K> keyCoder, Coder<AccumT> inputCoder) throws CannotProvideCoderException {
            return ListCoder.of(this.appliedCombineFn.getAccumulatorCoder());
        }
    }

    static final class Factory
    implements ParDoFnFactory {
        Factory() {
        }

        @Override
        public ParDoFn create(PipelineOptions options, CloudObject cloudUserFn, String stepName, String transformName, @Nullable List<SideInputInfo> sideInputInfos, @Nullable List<MultiOutputInfo> multiOutputInfos, int numOutputs, DataflowExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) throws Exception {
            Object windowingStrategyObj;
            byte[] encodedWindowingStrategy = Structs.getBytes((Map<String, Object>)((Object)cloudUserFn), "serialized_fn");
            if (encodedWindowingStrategy.length == 0) {
                windowingStrategyObj = WindowingStrategy.globalDefault();
            } else {
                windowingStrategyObj = SerializableUtils.deserializeFromByteArray(encodedWindowingStrategy, "serialized windowing strategy");
                String string = String.valueOf(windowingStrategyObj.getClass().getName());
                Preconditions.checkArgument(windowingStrategyObj instanceof WindowingStrategy, string.length() != 0 ? "unexpected kind of WindowingStrategy: ".concat(string) : new String("unexpected kind of WindowingStrategy: "));
            }
            WindowingStrategy<Object, GlobalWindow> windowingStrategy = windowingStrategyObj;
            byte[] serializedCombineFn = Structs.getBytes((Map<String, Object>)((Object)cloudUserFn), "combine_fn", null);
            AppliedCombineFn combineFn = null;
            if (serializedCombineFn != null) {
                Object combineFnObj = SerializableUtils.deserializeFromByteArray(serializedCombineFn, "serialized combine fn");
                String string = String.valueOf(combineFnObj.getClass().getName());
                Preconditions.checkArgument(combineFnObj instanceof AppliedCombineFn, string.length() != 0 ? "unexpected kind of AppliedCombineFn: ".concat(string) : new String("unexpected kind of AppliedCombineFn: "));
                combineFn = (AppliedCombineFn)combineFnObj;
            }
            Map<String, Object> inputCoderObject = Structs.getObject((Map<String, Object>)((Object)cloudUserFn), "input_coder");
            Coder inputCoder = Serializer.deserialize(inputCoderObject, Coder.class);
            String string = String.valueOf(inputCoder.getClass().getName());
            Preconditions.checkArgument(inputCoder instanceof WindowedValue.WindowedValueCoder, string.length() != 0 ? "Expected WindowedValueCoder for inputCoder, got: ".concat(string) : new String("Expected WindowedValueCoder for inputCoder, got: "));
            WindowedValue.WindowedValueCoder windowedValueCoder = (WindowedValue.WindowedValueCoder)inputCoder;
            Coder elemCoder = windowedValueCoder.getValueCoder();
            String string2 = String.valueOf(elemCoder.getClass().getName());
            Preconditions.checkArgument(elemCoder instanceof KvCoder, string2.length() != 0 ? "Expected KvCoder for inputCoder, got: ".concat(string2) : new String("Expected KvCoder for inputCoder, got: "));
            KvCoder kvCoder = (KvCoder)elemCoder;
            boolean isStreamingPipeline = options.as(StreamingOptions.class).isStreaming();
            AppliedCombineFn maybeMergingCombineFn = null;
            if (combineFn != null) {
                String phase;
                String string3 = String.valueOf(phase);
                phase = Structs.getString((Map<String, Object>)((Object)cloudUserFn), "phase", "all");
                Preconditions.checkArgument(phase.equals("all") || phase.equals("merge"), string3.length() != 0 ? "Unexpected phase: ".concat(string3) : new String("Unexpected phase: "));
                maybeMergingCombineFn = phase.equals("merge") ? GroupAlsoByWindowsParDoFn.makeAppliedMergingFunction(combineFn) : combineFn;
            }
            DoFn groupAlsoByWindowsDoFn = GroupAlsoByWindowsParDoFn.getGroupAlsoByWindowsDoFn(isStreamingPipeline, windowingStrategy, kvCoder, maybeMergingCombineFn);
            return GroupAlsoByWindowsParDoFn.of(options, groupAlsoByWindowsDoFn, stepName, transformName, executionContext, addCounterMutator, stateSampler);
        }
    }
}

