/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.io.range.RangeTracker;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.runners.worker.ByteArrayShufflePosition;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupingShuffleRangeTracker
implements RangeTracker<ByteArrayShufflePosition> {
    private static final Logger LOG = LoggerFactory.getLogger(GroupingShuffleRangeTracker.class);
    @Nullable
    private final ByteArrayShufflePosition startPosition;
    @Nullable
    private ByteArrayShufflePosition stopPosition;
    private ByteArrayShufflePosition lastGroupStart = null;
    private boolean lastGroupWasAtSplitPoint = false;

    public GroupingShuffleRangeTracker(@Nullable ByteArrayShufflePosition startPosition, @Nullable ByteArrayShufflePosition stopPosition) {
        this.startPosition = startPosition;
        this.stopPosition = stopPosition;
    }

    @Override
    public ByteArrayShufflePosition getStartPosition() {
        return this.startPosition;
    }

    @Override
    public synchronized ByteArrayShufflePosition getStopPosition() {
        return this.stopPosition;
    }

    public synchronized ByteArrayShufflePosition getLastGroupStart() {
        return this.lastGroupStart;
    }

    @Override
    public synchronized boolean tryReturnRecordAt(boolean isAtSplitPoint, ByteArrayShufflePosition groupStart) {
        int comparedToLast;
        if (this.lastGroupStart == null && !isAtSplitPoint) {
            throw new IllegalStateException(String.format("The first group [at %s] must be at a split point", groupStart.encodeBase64()));
        }
        if (this.startPosition != null && groupStart.compareTo(this.startPosition) < 0) {
            throw new IllegalStateException(String.format("Trying to return record at %s which is before the starting position at %s", groupStart, this.startPosition));
        }
        int n = comparedToLast = this.lastGroupStart == null ? 1 : groupStart.compareTo(this.lastGroupStart);
        if (comparedToLast < 0) {
            throw new IllegalStateException(String.format("Trying to return group at %s which is before the last-returned group at %s", groupStart, this.lastGroupStart));
        }
        if (isAtSplitPoint) {
            if (comparedToLast == 0) {
                throw new IllegalStateException(String.format("Trying to return a group at a split point with same position as the previous group: both at %s, last group was %s", groupStart, this.lastGroupWasAtSplitPoint ? "at a split point." : "not at a split point."));
            }
            if (this.stopPosition != null && groupStart.compareTo(this.stopPosition) >= 0) {
                return false;
            }
        } else if (comparedToLast != 0) {
            throw new IllegalStateException(String.format("Trying to return a group not at a split point, but with a different position than the previous group: last group was %s at %s, current at %s", this.lastGroupWasAtSplitPoint ? "a split point" : "a non-split point", this.lastGroupStart, groupStart));
        }
        this.lastGroupStart = groupStart;
        this.lastGroupWasAtSplitPoint = isAtSplitPoint;
        return true;
    }

    @Override
    public synchronized boolean trySplitAtPosition(ByteArrayShufflePosition splitPosition) {
        if (this.lastGroupStart == null) {
            LOG.debug("Refusing to split {} at {}: unstarted", (Object)this, (Object)splitPosition);
            return false;
        }
        if (splitPosition.compareTo(this.lastGroupStart) <= 0) {
            LOG.debug("Refusing to split {} at {}: already past proposed split position", (Object)this, (Object)splitPosition);
            return false;
        }
        if (this.stopPosition != null && splitPosition.compareTo(this.stopPosition) >= 0 || this.startPosition != null && splitPosition.compareTo(this.startPosition) <= 0) {
            LOG.error("Refusing to split {} at {}: proposed split position out of range", (Object)this, (Object)splitPosition);
            return false;
        }
        LOG.debug("Agreeing to split {} at {}", (Object)this, (Object)splitPosition);
        this.stopPosition = splitPosition;
        return true;
    }

    @Override
    public synchronized double getFractionConsumed() {
        throw new UnsupportedOperationException();
    }

    public synchronized String toString() {
        if (this.lastGroupStart != null) {
            return String.format("<at position %s of shuffle range [%s, %s)>", this.lastGroupStart, this.startPosition, this.stopPosition);
        }
        return String.format("<unstarted in shuffle range [%s, %s)>", this.startPosition, this.stopPosition);
    }

    @VisibleForTesting
    GroupingShuffleRangeTracker copy() {
        GroupingShuffleRangeTracker res = new GroupingShuffleRangeTracker(this.startPosition, this.stopPosition);
        res.lastGroupStart = this.lastGroupStart;
        res.lastGroupWasAtSplitPoint = this.lastGroupWasAtSplitPoint;
        return res;
    }
}

