/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.client.util.Preconditions;
import com.google.api.services.dataflow.model.ApproximateProgress;
import com.google.api.services.dataflow.model.Position;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.io.range.OffsetRangeTracker;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.runners.worker.SourceTranslationUtils;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import com.google.cloud.dataflow.sdk.util.common.worker.AbstractBoundedReaderIterator;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryReader<T>
extends Reader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryReader.class);
    final List<String> encodedElements;
    final int startIndex;
    final int endIndex;
    final Coder<T> coder;

    public InMemoryReader(List<String> encodedElements, @Nullable Long startIndex, @Nullable Long endIndex, Coder<T> coder) {
        this.encodedElements = encodedElements;
        int maxIndex = encodedElements.size();
        if (startIndex == null) {
            this.startIndex = 0;
        } else {
            if (startIndex < 0L) {
                throw new IllegalArgumentException("start index should be >= 0");
            }
            this.startIndex = (int)Math.min(startIndex, (long)maxIndex);
        }
        if (endIndex == null) {
            this.endIndex = maxIndex;
        } else {
            if (endIndex < (long)this.startIndex) {
                throw new IllegalArgumentException("end index should be >= start index");
            }
            this.endIndex = (int)Math.min(endIndex, (long)maxIndex);
        }
        this.coder = coder;
    }

    @Override
    public Reader.ReaderIterator<T> iterator() throws IOException {
        return new InMemoryReaderIterator();
    }

    class InMemoryReaderIterator
    extends AbstractBoundedReaderIterator<T> {
        @VisibleForTesting
        OffsetRangeTracker tracker;
        private int nextIndex;

        public InMemoryReaderIterator() {
            this.tracker = new OffsetRangeTracker(InMemoryReader.this.startIndex, InMemoryReader.this.endIndex);
            this.nextIndex = InMemoryReader.this.startIndex;
        }

        @Override
        protected boolean hasNextImpl() {
            return this.tracker.tryReturnRecordAt(true, this.nextIndex);
        }

        @Override
        protected T nextImpl() throws IOException {
            String encodedElementString = InMemoryReader.this.encodedElements.get(this.nextIndex++);
            byte[] encodedElement = StringUtils.jsonStringToByteArray(encodedElementString);
            InMemoryReader.this.notifyElementRead(encodedElement.length);
            return CoderUtils.decodeFromByteArray(InMemoryReader.this.coder, encodedElement);
        }

        @Override
        public Reader.Progress getProgress() {
            Position currentPosition = new Position();
            currentPosition.setRecordIndex(Long.valueOf(this.nextIndex));
            ApproximateProgress progress = new ApproximateProgress();
            progress.setPosition(currentPosition);
            return SourceTranslationUtils.cloudProgressToReaderProgress(progress);
        }

        @Override
        public Reader.DynamicSplitResult requestDynamicSplit(Reader.DynamicSplitRequest splitRequest) {
            Preconditions.checkNotNull((Object)splitRequest);
            Position splitPosition = SourceTranslationUtils.splitRequestToApproximateProgress(splitRequest).getPosition();
            if (splitPosition == null) {
                LOG.warn("InMemoryReader only supports split at a Position. Requested: {}", (Object)splitRequest);
                return null;
            }
            Long splitIndex = splitPosition.getRecordIndex();
            if (splitIndex == null) {
                LOG.warn("InMemoryReader only supports split at a record index. Requested: {}", (Object)splitPosition);
                return null;
            }
            if (!this.tracker.trySplitAtPosition(splitIndex)) {
                return null;
            }
            return new Reader.DynamicSplitResultWithPosition(SourceTranslationUtils.cloudPositionToReaderPosition(splitPosition));
        }
    }
}

