/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.util.common.worker.AbstractBoundedReaderIterator;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.io.IOException;
import java.util.Iterator;

abstract class LazyMultiReaderIterator<T>
extends AbstractBoundedReaderIterator<T> {
    private final Iterator<String> inputs;
    Reader.ReaderIterator<T> current;

    public LazyMultiReaderIterator(Iterator<String> inputs) {
        this.inputs = inputs;
    }

    @Override
    protected boolean hasNextImpl() throws IOException {
        while (this.selectReader()) {
            if (!this.current.hasNext()) {
                this.current.close();
                this.current = null;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    protected T nextImpl() throws IOException {
        return this.current.next();
    }

    @Override
    public void close() throws IOException {
        while (this.selectReader()) {
            this.current.close();
            this.current = null;
        }
    }

    protected abstract Reader.ReaderIterator<T> open(String var1) throws IOException;

    boolean selectReader() throws IOException {
        if (this.current != null) {
            return true;
        }
        if (this.inputs.hasNext()) {
            this.current = this.open(this.inputs.next());
            return true;
        }
        return false;
    }
}

