/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.cloud.dataflow.sdk.runners.worker.windmill.Windmill;
import com.google.cloud.dataflow.sdk.runners.worker.windmill.WindmillServerStub;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;

public class MetricTrackingWindmillServerStub {
    private final AtomicInteger activeSideInputs = new AtomicInteger();
    private final AtomicInteger activeStateReads = new AtomicInteger();
    private final WindmillServerStub server;

    public MetricTrackingWindmillServerStub(WindmillServerStub server) {
        this.server = server;
    }

    public Windmill.GetDataResponse getStateData(Windmill.GetDataRequest request) {
        this.activeStateReads.getAndIncrement();
        try {
            Windmill.GetDataResponse getDataResponse = this.server.getData(request);
            return getDataResponse;
        }
        finally {
            this.activeStateReads.getAndDecrement();
        }
    }

    public Windmill.GetDataResponse getSideInputData(Windmill.GetDataRequest request) {
        this.activeSideInputs.getAndIncrement();
        try {
            Windmill.GetDataResponse getDataResponse = this.server.getData(request);
            return getDataResponse;
        }
        finally {
            this.activeSideInputs.getAndDecrement();
        }
    }

    public void printHtml(PrintWriter writer) {
        writer.println("Active Fetches:");
        int n = this.activeSideInputs.get();
        writer.println(new StringBuilder(26).append("  Side Inputs: ").append(n).toString());
        n = this.activeStateReads.get();
        writer.println(new StringBuilder(26).append("  State Reads: ").append(n).toString());
    }

    public AutoCloseable sideInput() {
        return this.initiate(this.activeSideInputs);
    }

    private AutoCloseable initiate(final AtomicInteger counter) {
        counter.getAndIncrement();
        return new AutoCloseable(){

            @Override
            public void close() {
                counter.getAndDecrement();
            }
        };
    }
}

