/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.MultiOutputInfo;
import com.google.api.services.dataflow.model.SideInputInfo;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.runners.worker.DataflowExecutionContext;
import com.google.cloud.dataflow.sdk.runners.worker.ParDoFnBase;
import com.google.cloud.dataflow.sdk.runners.worker.ParDoFnFactory;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.DoFnInfo;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.NullSideInputReader;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import com.google.cloud.dataflow.sdk.util.SideInputReader;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.ParDoFn;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class NormalParDoFn
extends ParDoFnBase {
    private final byte[] serializedDoFn;
    private final DoFnInfo<?, ?> doFnInfo;

    static NormalParDoFn of(PipelineOptions options, DoFnInfo<?, ?> doFnInfo, SideInputReader sideInputReader, List<String> outputTags, String stepName, String transformName, DataflowExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        return new NormalParDoFn(options, doFnInfo, sideInputReader, outputTags, stepName, transformName, executionContext, addCounterMutator, stateSampler);
    }

    private NormalParDoFn(PipelineOptions options, DoFnInfo<?, ?> doFnInfo, SideInputReader sideInputReader, List<String> outputTags, String stepName, String transformName, ExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        super(options, sideInputReader, outputTags, stepName, transformName, executionContext, addCounterMutator, stateSampler);
        this.serializedDoFn = SerializableUtils.serializeToByteArray(doFnInfo.getDoFn());
        this.doFnInfo = doFnInfo;
    }

    protected DoFnInfo getDoFnInfo() {
        DoFn userDoFn = (DoFn)SerializableUtils.deserializeFromByteArray(this.serializedDoFn, "serialized user fun");
        return new DoFnInfo(userDoFn, this.doFnInfo.getWindowingStrategy(), this.doFnInfo.getSideInputViews(), this.doFnInfo.getInputCoder());
    }

    static final class Factory
    implements ParDoFnFactory {
        Factory() {
        }

        @Override
        public ParDoFn create(PipelineOptions options, CloudObject cloudUserFn, String stepName, String transformName, @Nullable List<SideInputInfo> sideInputInfos, @Nullable List<MultiOutputInfo> multiOutputInfos, int numOutputs, DataflowExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) throws Exception {
            Object deserializedFnInfo = SerializableUtils.deserializeFromByteArray(Structs.getBytes((Map<String, Object>)((Object)cloudUserFn), "serialized_fn"), "serialized fn info");
            if (!(deserializedFnInfo instanceof DoFnInfo)) {
                String string = String.valueOf(deserializedFnInfo.getClass().getName());
                throw new Exception(string.length() != 0 ? "unexpected kind of DoFnInfo: ".concat(string) : new String("unexpected kind of DoFnInfo: "));
            }
            DoFnInfo doFnInfo = (DoFnInfo)deserializedFnInfo;
            Iterable<PCollectionView<?>> sideInputViews = doFnInfo.getSideInputViews();
            SideInputReader sideInputReader = sideInputInfos != null && !sideInputInfos.isEmpty() ? executionContext.getSideInputReader(sideInputInfos) : (sideInputViews != null && Iterables.size(sideInputViews) > 0 ? executionContext.getSideInputReaderForViews(sideInputViews) : NullSideInputReader.empty());
            ArrayList<String> outputTags = new ArrayList<String>();
            if (multiOutputInfos != null) {
                for (MultiOutputInfo multiOutputInfo : multiOutputInfos) {
                    outputTags.add(multiOutputInfo.getTag());
                }
            }
            if (outputTags.isEmpty()) {
                outputTags.add("output");
            }
            if (numOutputs != outputTags.size()) {
                throw new AssertionError((Object)"unexpected number of outputTags for DoFn");
            }
            return NormalParDoFn.of(options, doFnInfo, sideInputReader, outputTags, stepName, transformName, executionContext, addCounterMutator, stateSampler);
        }
    }
}

