/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.MultiOutputInfo;
import com.google.api.services.dataflow.model.SideInputInfo;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.runners.worker.AssignWindowsParDoFn;
import com.google.cloud.dataflow.sdk.runners.worker.CombineValuesFn;
import com.google.cloud.dataflow.sdk.runners.worker.DataflowExecutionContext;
import com.google.cloud.dataflow.sdk.runners.worker.GroupAlsoByWindowsParDoFn;
import com.google.cloud.dataflow.sdk.runners.worker.NormalParDoFn;
import com.google.cloud.dataflow.sdk.runners.worker.ReifyTimestampAndWindowsParDoFn;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.ParDoFn;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ParDoFnFactory {
    public ParDoFn create(PipelineOptions var1, CloudObject var2, String var3, String var4, List<SideInputInfo> var5, List<MultiOutputInfo> var6, int var7, DataflowExecutionContext var8, CounterSet.AddCounterMutator var9, StateSampler var10) throws Exception;

    public static class DefaultFactory
    implements ParDoFnFactory {
        private final Map<String, ParDoFnFactory> defaultFactories = new HashMap<String, ParDoFnFactory>();

        public DefaultFactory() {
            this.defaultFactories.put("DoFn", new NormalParDoFn.Factory());
            this.defaultFactories.put("CombineValuesFn", new CombineValuesFn.Factory());
            this.defaultFactories.put("MergeBucketsDoFn", new GroupAlsoByWindowsParDoFn.Factory());
            this.defaultFactories.put("AssignBucketsDoFn", new AssignWindowsParDoFn.Factory());
            this.defaultFactories.put("MergeWindowsDoFn", new GroupAlsoByWindowsParDoFn.Factory());
            this.defaultFactories.put("AssignWindowsDoFn", new AssignWindowsParDoFn.Factory());
            this.defaultFactories.put("ReifyTimestampAndWindowsDoFn", new ReifyTimestampAndWindowsParDoFn.Factory());
        }

        @Override
        public ParDoFn create(PipelineOptions options, CloudObject cloudUserFn, String stepName, String transformName, List<SideInputInfo> sideInputInfos, List<MultiOutputInfo> multiOutputInfos, int numOutputs, DataflowExecutionContext executionContext, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) throws Exception {
            String className = cloudUserFn.getClassName();
            ParDoFnFactory factory = this.defaultFactories.get(className);
            if (factory == null) {
                String string = String.valueOf(className);
                throw new Exception(string.length() != 0 ? "No known ParDoFnFactory for ".concat(string) : new String("No known ParDoFnFactory for "));
            }
            return factory.create(options, cloudUserFn, stepName, transformName, sideInputInfos, multiOutputInfos, numOutputs, executionContext, addCounterMutator, stateSampler);
        }
    }
}

