/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.worker;

import com.google.api.services.dataflow.model.Source;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.runners.dataflow.BasicSerializableSourceFormat;
import com.google.cloud.dataflow.sdk.runners.worker.AvroReaderFactory;
import com.google.cloud.dataflow.sdk.runners.worker.BigQueryReaderFactory;
import com.google.cloud.dataflow.sdk.runners.worker.ConcatReaderFactory;
import com.google.cloud.dataflow.sdk.runners.worker.GroupingShuffleReaderFactory;
import com.google.cloud.dataflow.sdk.runners.worker.InMemoryReaderFactory;
import com.google.cloud.dataflow.sdk.runners.worker.PartitioningShuffleReaderFactory;
import com.google.cloud.dataflow.sdk.runners.worker.PubsubReader;
import com.google.cloud.dataflow.sdk.runners.worker.TextReaderFactory;
import com.google.cloud.dataflow.sdk.runners.worker.UngroupedShuffleReaderFactory;
import com.google.cloud.dataflow.sdk.runners.worker.UngroupedWindmillReader;
import com.google.cloud.dataflow.sdk.runners.worker.WindowingWindmillReader;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.CloudSourceUtils;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.Serializer;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public interface ReaderFactory {
    public Reader<?> create(CloudObject var1, @Nullable Coder<?> var2, @Nullable PipelineOptions var3, @Nullable ExecutionContext var4, @Nullable CounterSet.AddCounterMutator var5, @Nullable String var6) throws Exception;

    public static class Registry
    implements ReaderFactory {
        private final Map<String, ReaderFactory> factories;

        public static Registry defaultRegistry() {
            HashMap<String, ReaderFactory> factories = Maps.newHashMap();
            factories.put("TextSource", TextReaderFactory.getInstance());
            factories.put("AvroSource", new AvroReaderFactory());
            factories.put("UngroupedShuffleSource", new UngroupedShuffleReaderFactory());
            factories.put("PartitioningShuffleSource", new PartitioningShuffleReaderFactory());
            factories.put("GroupingShuffleSource", new GroupingShuffleReaderFactory());
            factories.put("InMemorySource", new InMemoryReaderFactory());
            factories.put("BigQuerySource", new BigQueryReaderFactory());
            factories.put("WindowingWindmillReader", new WindowingWindmillReader.Factory());
            factories.put("com.google.cloud.dataflow.sdk.runners.worker.WindowingWindmillReader", new WindowingWindmillReader.Factory());
            factories.put("com.google.cloud.dataflow.sdk.runners.worker.BucketingWindmillSource", new WindowingWindmillReader.Factory());
            factories.put("UngroupedWindmillReader", new UngroupedWindmillReader.Factory());
            factories.put("com.google.cloud.dataflow.sdk.runners.worker.UngroupedWindmillSource", new UngroupedWindmillReader.Factory());
            factories.put("com.google.cloud.dataflow.sdk.runners.worker.UngroupedWindmillReader", new UngroupedWindmillReader.Factory());
            factories.put("PubsubReader", new PubsubReader.Factory());
            factories.put("com.google.cloud.dataflow.sdk.runners.worker.PubsubSource", new PubsubReader.Factory());
            factories.put("com.google.cloud.dataflow.sdk.runners.dataflow.BasicSerializableSourceFormat", new BasicSerializableSourceFormat.Factory());
            return new Registry(factories);
        }

        private Registry(Map<String, ReaderFactory> factories) {
            this.factories = factories;
            this.factories.put("ConcatSource", ConcatReaderFactory.withRegistry(this));
        }

        public Registry register(String readerSpecType, ReaderFactory factory) {
            HashMap<String, ReaderFactory> newFactories = Maps.newHashMap();
            newFactories.putAll(this.factories);
            newFactories.put(readerSpecType, factory);
            return new Registry(newFactories);
        }

        @Override
        public Reader<?> create(CloudObject sourceSpec, @Nullable Coder<?> coder, @Nullable PipelineOptions options, @Nullable ExecutionContext executionContext, @Nullable CounterSet.AddCounterMutator addCounterMutator, @Nullable String operationName) throws Exception {
            String objClassName = sourceSpec.getClassName();
            ReaderFactory readerFactory = this.factories.get(objClassName);
            if (readerFactory == null) {
                throw new IllegalArgumentException(String.format("Unable to create a Reader: Unknown Reader type in Source specification: %s", objClassName));
            }
            return readerFactory.create(sourceSpec, coder, options, executionContext, addCounterMutator, operationName);
        }

        public Reader<?> create(Source cloudSource, @Nullable PipelineOptions options, @Nullable ExecutionContext executionContext, @Nullable CounterSet.AddCounterMutator addCounterMutator, @Nullable String operationName) throws Exception {
            cloudSource = CloudSourceUtils.flattenBaseSpecs(cloudSource);
            CloudObject sourceSpec = CloudObject.fromSpec(cloudSource.getSpec());
            Coder coder = null;
            if (cloudSource.getCodec() != null) {
                coder = Serializer.deserialize(cloudSource.getCodec(), Coder.class);
            }
            return this.create(sourceSpec, coder, options, executionContext, addCounterMutator, operationName);
        }
    }
}

